/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.marmalade.util.ReflectorException;

public final class Reflector {
    private static final String CONSTRUCTOR_METHOD_NAME = "$$CONSTRUCTOR$$";
    private static final String GET_INSTANCE_METHOD_NAME = "getInstance";
    private HashMap classMaps = new HashMap();

    public Constructor getConstructor(Class clazz, Class[] classArray) throws ReflectorException {
        Map map = this.getConstructorMap(clazz);
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("(");
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            stringBuffer.append(classArray[n].getName());
            stringBuffer.append(",");
            ++n;
        }
        if (classArray.length > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        stringBuffer.append(")");
        Constructor<?> constructor = null;
        String string = stringBuffer.toString();
        String string2 = string.intern();
        synchronized (string2) {
            constructor = (Constructor<?>)map.get(string);
            if (constructor == null) {
                Constructor<?>[] constructorArray = clazz.getConstructors();
                int n3 = 0;
                int n4 = constructorArray.length;
                while (n3 < n4) {
                    Class<?>[] classArray2 = constructorArray[n3].getParameterTypes();
                    if (classArray.length == classArray2.length) {
                        int n5 = 0;
                        int n6 = classArray.length;
                        while (n5 < n6) {
                            if (!classArray2[n5].isAssignableFrom(classArray[n5])) {
                                // empty if block
                            }
                            ++n5;
                        }
                        constructor = constructorArray[n3];
                        map.put(string, constructor);
                    }
                    ++n3;
                }
            }
        }
        if (constructor == null) {
            throw new ReflectorException("Error retrieving constructor object for: " + clazz.getName() + string);
        }
        return constructor;
    }

    private Map getConstructorMap(Class clazz) throws ReflectorException {
        return this.getMethodMap(clazz, CONSTRUCTOR_METHOD_NAME);
    }

    public Object getField(Object object, String string) throws ReflectorException {
        try {
            Class<?> clazz = object.getClass();
            Field field = clazz.getField(string);
            return field.get(object);
        }
        catch (SecurityException securityException) {
            throw new ReflectorException(securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectorException(noSuchFieldException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectorException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectorException(illegalAccessException);
        }
    }

    public Method getMethod(Class clazz, String string, Class[] classArray) throws ReflectorException {
        Map map = this.getMethodMap(clazz, string);
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("(");
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            stringBuffer.append(classArray[n].getName());
            stringBuffer.append(",");
            ++n;
        }
        stringBuffer.append(")");
        Method method = null;
        String string2 = stringBuffer.toString();
        String string3 = string2.intern();
        synchronized (string3) {
            method = (Method)map.get(string2);
            if (method == null) {
                Method[] methodArray = clazz.getMethods();
                int n3 = 0;
                int n4 = methodArray.length;
                while (n3 < n4) {
                    Class<?>[] classArray2;
                    String string4 = methodArray[n3].getName();
                    if (string.equals(string4) && classArray.length == (classArray2 = methodArray[n3].getParameterTypes()).length) {
                        int n5 = 0;
                        int n6 = classArray.length;
                        while (n5 < n6) {
                            if (!classArray2[n5].isAssignableFrom(classArray[n5])) {
                                // empty if block
                            }
                            ++n5;
                        }
                        method = methodArray[n3];
                        map.put(string2, method);
                    }
                    ++n3;
                }
            }
        }
        if (method == null) {
            throw new ReflectorException("Error retrieving method object for: " + clazz.getName() + "." + string + string2);
        }
        return method;
    }

    private Map getMethodMap(Class clazz, String string) throws ReflectorException {
        Map map = null;
        if (clazz == null) {
            return null;
        }
        String string2 = clazz.getName();
        String string3 = string2.intern();
        synchronized (string3) {
            HashMap hashMap = (HashMap)this.classMaps.get(string2);
            if (hashMap == null) {
                hashMap = new HashMap();
                map = new HashMap();
                hashMap.put(string, map);
                this.classMaps.put(string2, hashMap);
            } else {
                String string4 = String.valueOf(string2) + "::" + string;
                String string5 = string4.intern();
                synchronized (string5) {
                    map = (Map)hashMap.get(string);
                    if (map == null) {
                        map = new HashMap();
                        hashMap.put(string, map);
                    }
                }
            }
        }
        return map;
    }

    public Object getSingleton(Class clazz, Object[] objectArray) throws ReflectorException {
        Class[] classArray = new Class[objectArray.length];
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            classArray[n] = objectArray[n].getClass();
            ++n;
        }
        try {
            Method method = this.getMethod(clazz, GET_INSTANCE_METHOD_NAME, classArray);
            return method.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectorException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectorException(illegalAccessException);
        }
    }

    public Object getStaticField(Class clazz, String string) throws ReflectorException {
        try {
            Field field = clazz.getField(string);
            return field.get(null);
        }
        catch (SecurityException securityException) {
            throw new ReflectorException(securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectorException(noSuchFieldException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectorException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectorException(illegalAccessException);
        }
    }

    public Object invoke(Object object, String string, Object[] objectArray) throws ReflectorException {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Class[] classArray = new Class[objectArray.length];
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            classArray[n] = objectArray[n].getClass();
            ++n;
        }
        try {
            Method method = this.getMethod(object.getClass(), string, classArray);
            if (method == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Singleton-producing method named '" + string + "' not found with specified parameter classes: ");
                int n3 = 0;
                while (n3 < classArray.length) {
                    stringBuffer.append(classArray[n3].getName());
                    stringBuffer.append(',');
                    ++n3;
                }
                stringBuffer.setLength(stringBuffer.length() - 1);
                throw new ReflectorException(stringBuffer.toString());
            }
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectorException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectorException(illegalAccessException);
        }
    }

    public Object invokeStatic(Class clazz, String string, Object[] objectArray) throws ReflectorException {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Class[] classArray = new Class[objectArray.length];
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            classArray[n] = objectArray[n].getClass();
            ++n;
        }
        try {
            Method method = this.getMethod(clazz, string, classArray);
            if (method == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Singleton-producing method named '" + string + "' not found with specified parameter classes: ");
                int n3 = 0;
                while (n3 < classArray.length) {
                    stringBuffer.append(classArray[n3].getName());
                    stringBuffer.append(',');
                    ++n3;
                }
                stringBuffer.setLength(stringBuffer.length() - 1);
                throw new ReflectorException(stringBuffer.toString());
            }
            return method.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectorException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectorException(illegalAccessException);
        }
    }

    public Object newInstance(Class clazz, Object[] objectArray) throws ReflectorException {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Class[] classArray = new Class[objectArray.length];
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            classArray[n] = objectArray[n].getClass();
            ++n;
        }
        try {
            Constructor constructor = this.getConstructor(clazz, classArray);
            if (constructor == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Constructor not found for class: ");
                stringBuffer.append(clazz.getName());
                stringBuffer.append(" with specified or ancestor parameter classes: ");
                int n3 = 0;
                while (n3 < classArray.length) {
                    stringBuffer.append(classArray[n3].getName());
                    stringBuffer.append(',');
                    ++n3;
                }
                stringBuffer.setLength(stringBuffer.length() - 1);
                throw new ReflectorException(stringBuffer.toString());
            }
            return constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectorException(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectorException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectorException(illegalAccessException);
        }
    }
}

