/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.marmalade.util.ReflectorException;

public final class Reflector {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$codehaus$marmalade$util$Reflector == null ? (class$org$codehaus$marmalade$util$Reflector = Reflector.class$("org.codehaus.marmalade.util.Reflector")) : class$org$codehaus$marmalade$util$Reflector));
    private static final String CONSTRUCTOR_METHOD_NAME = "$$CONSTRUCTOR$$";
    private static final String GET_INSTANCE_METHOD_NAME = "getInstance";
    private HashMap classMaps = new HashMap();
    static /* synthetic */ Class class$org$codehaus$marmalade$util$Reflector;

    public Object newInstance(Class theClass, Object[] params) throws ReflectorException {
        if (params == null) {
            params = new Object[]{};
        }
        Class[] paramTypes = new Class[params.length];
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            paramTypes[i] = params[i].getClass();
        }
        try {
            Constructor con = this.getConstructor(theClass, paramTypes);
            if (con == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Constructor not found for class: ");
                buffer.append(theClass.getName());
                buffer.append(" with specified or ancestor parameter classes: ");
                for (int i = 0; i < paramTypes.length; ++i) {
                    buffer.append(paramTypes[i].getName());
                    buffer.append(',');
                }
                buffer.setLength(buffer.length() - 1);
                throw new ReflectorException(buffer.toString());
            }
            return con.newInstance(params);
        }
        catch (InstantiationException ex) {
            throw new ReflectorException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectorException(ex);
        }
    }

    public Object getSingleton(Class theClass, Object[] initParams) throws ReflectorException {
        Class[] paramTypes = new Class[initParams.length];
        int len = initParams.length;
        for (int i = 0; i < len; ++i) {
            paramTypes[i] = initParams[i].getClass();
        }
        try {
            Method method = this.getMethod(theClass, GET_INSTANCE_METHOD_NAME, paramTypes);
            return method.invoke(null, initParams);
        }
        catch (InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectorException(ex);
        }
    }

    public Object invoke(Object target, String methodName, Object[] params) throws ReflectorException {
        if (params == null) {
            params = new Object[]{};
        }
        Class[] paramTypes = new Class[params.length];
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            paramTypes[i] = params[i].getClass();
        }
        try {
            Method method = this.getMethod(target.getClass(), methodName, paramTypes);
            if (method == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Singleton-producing method named '" + methodName + "' not found with specified parameter classes: ");
                for (int i = 0; i < paramTypes.length; ++i) {
                    buffer.append(paramTypes[i].getName());
                    buffer.append(',');
                }
                buffer.setLength(buffer.length() - 1);
                throw new ReflectorException(buffer.toString());
            }
            return method.invoke(target, params);
        }
        catch (InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectorException(ex);
        }
    }

    public Object getStaticField(Class targetClass, String fieldName) throws ReflectorException {
        try {
            Field field = targetClass.getField(fieldName);
            return field.get(null);
        }
        catch (SecurityException e) {
            throw new ReflectorException(e);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectorException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectorException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectorException(e);
        }
    }

    public Object getField(Object target, String fieldName) throws ReflectorException {
        try {
            Class<?> targetClass = target.getClass();
            Field field = targetClass.getField(fieldName);
            return field.get(target);
        }
        catch (SecurityException e) {
            throw new ReflectorException(e);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectorException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectorException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectorException(e);
        }
    }

    public Object invokeStatic(Class targetClass, String methodName, Object[] params) throws ReflectorException {
        if (params == null) {
            params = new Object[]{};
        }
        Class[] paramTypes = new Class[params.length];
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            paramTypes[i] = params[i].getClass();
        }
        try {
            Method method = this.getMethod(targetClass, methodName, paramTypes);
            if (method == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Singleton-producing method named '" + methodName + "' not found with specified parameter classes: ");
                for (int i = 0; i < paramTypes.length; ++i) {
                    buffer.append(paramTypes[i].getName());
                    buffer.append(',');
                }
                buffer.setLength(buffer.length() - 1);
                throw new ReflectorException(buffer.toString());
            }
            return method.invoke(null, params);
        }
        catch (InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectorException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constructor getConstructor(Class targetClass, Class[] params) throws ReflectorException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Target class: " + targetClass));
        }
        Map constructorMap = this.getConstructorMap(targetClass);
        StringBuffer key = new StringBuffer(200);
        key.append("(");
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            key.append(params[i].getName());
            key.append(",");
        }
        if (params.length > 0) {
            key.setLength(key.length() - 1);
        }
        key.append(")");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("searching for key: '" + key + "'"));
        }
        Constructor<?> constructor = null;
        String paramKey = key.toString();
        String string = paramKey.intern();
        synchronized (string) {
            constructor = (Constructor<?>)constructorMap.get(paramKey);
            if (constructor == null) {
                Constructor<?>[] cands = targetClass.getConstructors();
                int len2 = cands.length;
                for (int i = 0; i < len2; ++i) {
                    Class<?>[] types = cands[i].getParameterTypes();
                    if (params.length != types.length) continue;
                    int len22 = params.length;
                    for (int j = 0; j < len22; ++j) {
                        if (types[j].isAssignableFrom(params[j])) continue;
                    }
                    constructor = cands[i];
                    constructorMap.put(paramKey, constructor);
                }
            }
        }
        if (constructor == null) {
            throw new ReflectorException("Error retrieving constructor object for: " + targetClass.getName() + paramKey);
        }
        return constructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getMethod(Class targetClass, String methodName, Class[] params) throws ReflectorException {
        Map methodMap = this.getMethodMap(targetClass, methodName);
        StringBuffer key = new StringBuffer(200);
        key.append("(");
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            key.append(params[i].getName());
            key.append(",");
        }
        key.append(")");
        Method method = null;
        String paramKey = key.toString();
        String string = paramKey.intern();
        synchronized (string) {
            method = (Method)methodMap.get(paramKey);
            if (method == null) {
                Method[] cands = targetClass.getMethods();
                int len2 = cands.length;
                for (int i = 0; i < len2; ++i) {
                    Class<?>[] types;
                    String name = cands[i].getName();
                    if (!methodName.equals(name) || params.length != (types = cands[i].getParameterTypes()).length) continue;
                    int len22 = params.length;
                    for (int j = 0; j < len22; ++j) {
                        if (types[j].isAssignableFrom(params[j])) continue;
                    }
                    method = cands[i];
                    methodMap.put(paramKey, method);
                }
            }
        }
        if (method == null) {
            throw new ReflectorException("Error retrieving method object for: " + targetClass.getName() + "." + methodName + paramKey);
        }
        return method;
    }

    private Map getConstructorMap(Class theClass) throws ReflectorException {
        return this.getMethodMap(theClass, CONSTRUCTOR_METHOD_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getMethodMap(Class theClass, String methodName) throws ReflectorException {
        Map methodMap = null;
        if (theClass == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"class was null. Aborting.");
            }
            return null;
        }
        String className = theClass.getName();
        String string = className.intern();
        synchronized (string) {
            HashMap classMethods = (HashMap)this.classMaps.get(className);
            if (classMethods == null) {
                classMethods = new HashMap();
                methodMap = new HashMap();
                classMethods.put(methodName, methodMap);
                this.classMaps.put(className, classMethods);
            } else {
                String key = className + "::" + methodName;
                String string2 = key.intern();
                synchronized (string2) {
                    methodMap = (Map)classMethods.get(methodName);
                    if (methodMap == null) {
                        methodMap = new HashMap();
                        classMethods.put(methodName, methodMap);
                    }
                }
            }
        }
        return methodMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

