/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.marmalade.util.ScopedMapEntriesIterator;
import org.codehaus.marmalade.util.ScopedMapEntry;

public class ScopedMapEntriesSet
implements Set {
    private Map superMap;
    private Map thisMap;
    private Boolean extractKey;
    private List entries = new ArrayList();

    public ScopedMapEntriesSet(Map map, Map map2, Boolean bl) {
        this.superMap = map;
        this.thisMap = map2;
        this.extractKey = bl;
        this.update();
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException("Add operation is not supported.");
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException("Add-all operation is not supported.");
    }

    public void clear() {
        this.thisMap.clear();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            ScopedMapEntry scopedMapEntry = (ScopedMapEntry)iterator.next();
            if (!scopedMapEntry.isMutable()) continue;
            iterator.remove();
        }
    }

    public boolean contains(Object object) {
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            if (!this.extract((ScopedMapEntry)iterator.next()).equals(object)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(this.extract((ScopedMapEntry)iterator.next()))) continue;
            return false;
        }
        return true;
    }

    Iterator entryIterator() {
        return this.entries.iterator();
    }

    public Object extract(ScopedMapEntry scopedMapEntry) {
        if (this.extractKey == null) {
            return scopedMapEntry;
        }
        if (Boolean.TRUE == this.extractKey) {
            return scopedMapEntry.getKey();
        }
        return scopedMapEntry.getValue();
    }

    public boolean isEmpty() {
        return this.thisMap.isEmpty() && this.superMap.isEmpty();
    }

    public Iterator iterator() {
        return new ScopedMapEntriesIterator(this, this.extractKey);
    }

    public boolean remove(Object object) {
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            ScopedMapEntry scopedMapEntry = (ScopedMapEntry)iterator.next();
            if (!this.extract(scopedMapEntry).equals(object)) continue;
            if (scopedMapEntry.isMutable()) {
                iterator.remove();
                this.thisMap.remove(scopedMapEntry.getKey());
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            ScopedMapEntry scopedMapEntry = (ScopedMapEntry)iterator.next();
            if (!collection.contains(this.extract(scopedMapEntry)) || !scopedMapEntry.isMutable()) continue;
            iterator.remove();
            this.thisMap.remove(scopedMapEntry.getKey());
            bl = true;
        }
        return bl;
    }

    void removeEntry(ScopedMapEntry scopedMapEntry) {
        if (scopedMapEntry.isMutable()) {
            this.entries.remove(scopedMapEntry);
            this.thisMap.remove(scopedMapEntry.getKey());
        }
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            ScopedMapEntry scopedMapEntry = (ScopedMapEntry)iterator.next();
            if (collection.contains(this.extract(scopedMapEntry)) || !scopedMapEntry.isMutable()) continue;
            iterator.remove();
            this.thisMap.remove(scopedMapEntry.getKey());
            bl = true;
        }
        return bl;
    }

    public int size() {
        return this.entries.size();
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.entries.size()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.extract((ScopedMapEntry)this.entries.get(n));
            ++n;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.entries.get(n);
            ++n;
        }
        if (this.entries.size() > objectArray.length) {
            throw new ArrayIndexOutOfBoundsException(objectArray.length);
        }
        return objectArray;
    }

    void update() {
        ScopedMapEntry scopedMapEntry;
        Object object;
        Map.Entry entry;
        Iterator iterator = this.superMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            object = entry.getKey();
            if (this.thisMap.containsKey(object)) continue;
            scopedMapEntry = new ScopedMapEntry(entry, false);
            this.entries.add(scopedMapEntry);
        }
        entry = this.thisMap.entrySet().iterator();
        while (entry.hasNext()) {
            object = (Map.Entry)entry.next();
            scopedMapEntry = new ScopedMapEntry((Map.Entry)object, true);
            this.entries.add(scopedMapEntry);
        }
    }
}

