/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.marmalade.util.ScopedMapEntriesSet;

public class ScopedMap
implements Map {
    private Map superMap;
    private Map thisMap;
    private ScopedMapEntriesSet keySet;
    private ScopedMapEntriesSet valueSet;
    private ScopedMapEntriesSet entrySet;

    public ScopedMap() {
        this.init(Collections.EMPTY_MAP);
    }

    public ScopedMap(Map map) {
        this.init(map);
    }

    public void clear() {
        this.thisMap.clear();
        this.update();
    }

    public boolean containsKey(Object object) {
        return this.thisMap.containsKey(object) || this.superMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.thisMap.containsValue(object) || this.superMap.containsValue(object);
    }

    public Set entrySet() {
        return this.entrySet;
    }

    public Object get(Object object) {
        Object v = this.thisMap.get(object);
        if (v == null) {
            v = this.superMap.get(object);
        }
        return v;
    }

    public Map getLocalMap() {
        return this.thisMap;
    }

    public Map getSuperMap() {
        return this.superMap;
    }

    private void init(Map map) {
        Map map2 = map;
        if (map2 == null) {
            map2 = Collections.EMPTY_MAP;
        }
        this.superMap = map2;
        this.thisMap = new HashMap();
        this.entrySet = new ScopedMapEntriesSet(map, this.thisMap, null);
        this.keySet = new ScopedMapEntriesSet(map, this.thisMap, Boolean.TRUE);
        this.valueSet = new ScopedMapEntriesSet(map, this.thisMap, Boolean.FALSE);
    }

    public boolean isEmpty() {
        return this.superMap.isEmpty() && this.thisMap.isEmpty();
    }

    public Set keySet() {
        return this.keySet;
    }

    public Object put(Object object, Object object2) {
        Object object3 = null;
        object3 = this.thisMap.put(object, object2);
        this.update();
        return object3;
    }

    public void putAll(Map map) {
        boolean bl = false;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (this.superMap.containsKey(k)) continue;
            this.thisMap.put(k, map.get(k));
            bl = true;
        }
        if (bl) {
            this.update();
        }
    }

    public Object remove(Object object) {
        Object v = this.thisMap.remove(object);
        if (v != null) {
            this.update();
        }
        return v;
    }

    public int size() {
        return this.superMap.size() + this.thisMap.size();
    }

    public String toString() {
        return "ScopedMap:\n==========================\nlocal:\n\t" + String.valueOf(this.thisMap) + "\n\nparent:\n\t" + String.valueOf(this.superMap);
    }

    private void update() {
        this.entrySet.update();
        this.keySet.update();
        this.valueSet.update();
    }

    public Collection values() {
        return this.valueSet;
    }
}

