/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.tags;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.codehaus.marmalade.model.AbstractMarmaladeTag;
import org.codehaus.marmalade.model.MarmaladeTag;
import org.codehaus.marmalade.runtime.MarmaladeExecutionContext;
import org.codehaus.marmalade.runtime.MarmaladeExecutionException;
import org.codehaus.marmalade.tags.LoopStatus;
import org.codehaus.marmalade.tags.LoopingTag;

public abstract class AbstractLoopingTag
extends AbstractMarmaladeTag
implements LoopingTag {
    private boolean shouldBreak = false;
    private boolean shouldContinue = false;

    protected AbstractLoopingTag() {
    }

    protected final boolean alwaysProcessChildren() {
        return false;
    }

    public final void breakLoop() {
        this.shouldBreak = true;
    }

    public final void continueLoop() {
        this.shouldContinue = true;
    }

    protected void doReset() {
        this.shouldBreak = false;
        this.shouldContinue = false;
    }

    protected final void executeLoop(LoopStep[] loopStepArray, String string, String string2, MarmaladeExecutionContext marmaladeExecutionContext) throws MarmaladeExecutionException {
        marmaladeExecutionContext.newScope();
        int n = 0;
        block0: while (n < loopStepArray.length) {
            LoopStep loopStep = loopStepArray[n];
            Object object = loopStep.getItem();
            marmaladeExecutionContext.setVariable(string, object);
            if (string2 != null && string2.length() > 0) {
                marmaladeExecutionContext.setVariable(string2, loopStep);
            }
            List list = this.children();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MarmaladeTag marmaladeTag = (MarmaladeTag)iterator.next();
                marmaladeTag.execute(marmaladeExecutionContext);
                if (this.shouldBreak) break block0;
                if (!this.shouldContinue) continue;
                this.shouldContinue = false;
                break;
            }
            ++n;
        }
        marmaladeExecutionContext.lastScope();
    }

    protected void getItemsFromArray(Object[] objectArray, List list, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < objectArray.length) {
            Object object = objectArray[n4];
            if (n4 >= n && (n4 <= n2 || n2 <= -1) && n4 % n3 == 0) {
                list.add(new LoopStep(object, n, n2, n3, n4));
            }
            ++n4;
        }
    }

    protected void getItemsFromCollection(Collection collection, List list, int n, int n2, int n3) {
        int n4 = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (n4 >= n && (n4 <= n2 || n2 <= -1) && n4 % n3 == 0) {
                list.add(new LoopStep(e, n, n2, n3, n4));
            }
            ++n4;
        }
    }

    protected void getItemsFromString(String string, String string2, List list, int n, int n2, int n3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n4 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (n4 >= n && (n4 <= n2 || n2 <= -1) && n4 % n3 == 0) {
                list.add(new LoopStep(string3, n, n2, n3, n4));
            }
            ++n4;
        }
    }

    public static final class LoopStep
    implements LoopStatus {
        private Object item;
        private int index;
        private int begin;
        private int end;
        private int step;

        public LoopStep(Object object, int n, int n2, int n3, int n4) {
            this.item = object;
            this.index = n4;
            this.begin = n;
            this.end = n2;
            this.step = n3;
        }

        public int getBegin() {
            return this.begin;
        }

        public int getEnd() {
            return this.end;
        }

        public int getIndex() {
            return this.index;
        }

        protected Object getItem() {
            return this.item;
        }

        public int getStep() {
            return this.step;
        }
    }
}

