/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.marmalade.el.ExpressionEvaluationException;
import org.codehaus.marmalade.el.ExpressionEvaluator;
import org.codehaus.marmalade.runtime.MarmaladeExecutionContext;
import org.codehaus.marmalade.util.ScopedMap;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class DefaultContext
implements MarmaladeExecutionContext {
    private static final PrintWriter SYSOUT = new PrintWriter(new OutputStreamWriter(System.out));
    private static final PrintWriter SYSERR = new PrintWriter(new OutputStreamWriter(System.err));
    private static final Reader SYSIN = new BufferedReader(new InputStreamReader(System.in));
    public static final String PRESERVE_WS_OVERRIDE_VARIABLE = "marmalade:preserve-whitespace-override";
    private Map context;
    private Map systemContext;
    private PrintWriter out = SYSOUT;
    private PrintWriter err = SYSERR;
    private Reader in = SYSIN;
    private XmlSerializer xmlSerializer;
    static /* synthetic */ Class class$java$lang$Object;

    public DefaultContext() {
        this.systemContext = Collections.unmodifiableMap(new TreeMap<Object, Object>(System.getProperties()));
        this.context = new ScopedMap(this.systemContext);
    }

    public DefaultContext(Map map) {
        this.systemContext = new HashMap();
        this.systemContext.putAll(System.getProperties());
        this.systemContext = Collections.unmodifiableMap(this.systemContext);
        this.context = new ScopedMap(this.systemContext);
        this.context.putAll(map);
    }

    private Map _lastScope(boolean bl) {
        Map map = null;
        if (this.context instanceof ScopedMap) {
            Map map2 = ((ScopedMap)this.context).getSuperMap();
            Map map3 = ((ScopedMap)this.context).getLocalMap();
            if (map2 != null && map2 instanceof ScopedMap) {
                this.context = map2;
                map = map3;
            }
        }
        if (map != null && bl) {
            this.context.putAll(map);
        }
        return map;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PrintWriter getErrWriter() {
        return this.err;
    }

    public Reader getInReader() {
        return this.in;
    }

    public PrintWriter getOutWriter() {
        return this.out;
    }

    public Object getVariable(Object object, ExpressionEvaluator expressionEvaluator) throws ExpressionEvaluationException {
        Object object2 = this.context.get(object);
        if (expressionEvaluator != null && object2 != null && object2 instanceof String) {
            object2 = expressionEvaluator.evaluate((String)object2, this.context, class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = DefaultContext.class$("java.lang.Object")));
        }
        return object2;
    }

    public XmlSerializer getXmlSerializer() throws XmlPullParserException, IOException {
        if (this.xmlSerializer == null) {
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            this.xmlSerializer = xmlPullParserFactory.newSerializer();
            this.xmlSerializer.setOutput((Writer)this.getOutWriter());
        }
        return this.xmlSerializer;
    }

    public void importContext(MarmaladeExecutionContext marmaladeExecutionContext) {
        Map map = marmaladeExecutionContext.unmodifiableVariableMap();
        this.context.putAll(map);
    }

    public Map lastScope() {
        return this._lastScope(false);
    }

    public Map lastScope(boolean bl) {
        return this._lastScope(bl);
    }

    public void newScope() {
        this.context = new ScopedMap(this.context);
    }

    public Boolean preserveWhitespaceOverride() {
        return (Boolean)this.context.get(PRESERVE_WS_OVERRIDE_VARIABLE);
    }

    public void preserveWhitespaceOverride(Boolean bl) {
        if (bl == null) {
            this.context.remove(PRESERVE_WS_OVERRIDE_VARIABLE);
        } else {
            this.context.put(PRESERVE_WS_OVERRIDE_VARIABLE, bl);
        }
    }

    public Object removeVariable(Object object) {
        Object v = this.context.remove(object);
        return v;
    }

    public void setErrWriter(PrintWriter printWriter) {
        this.err = printWriter;
    }

    public void setInReader(Reader reader) {
        this.in = reader;
    }

    public void setOutWriter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public Object setVariable(Object object, Object object2) {
        return this.context.put(object, object2);
    }

    public void setVariables(Map map) {
        this.context.putAll(map);
    }

    public Map unmodifiableVariableMap() {
        return Collections.unmodifiableMap(this.context);
    }
}

