/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.compat.jelly.model;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jelly.DynaTag;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.XMLOutput;
import org.codehaus.marmalade.compat.jelly.JellyCompatUncheckedException;
import org.codehaus.marmalade.compat.jelly.metamodel.JellyCompatMarmaladeTaglib;
import org.codehaus.marmalade.compat.jelly.model.MarmaladeCompatBodyScript;
import org.codehaus.marmalade.compat.jelly.runtime.MarmaladeCompatJellyContext;
import org.codehaus.marmalade.compat.jelly.runtime.MarmaladeCompatJellyExpression;
import org.codehaus.marmalade.compat.jelly.util.SAXAttributesWrapper;
import org.codehaus.marmalade.el.ExpressionEvaluationException;
import org.codehaus.marmalade.el.ExpressionEvaluator;
import org.codehaus.marmalade.metamodel.MarmaladeTagInfo;
import org.codehaus.marmalade.model.MarmaladeAttribute;
import org.codehaus.marmalade.model.MarmaladeAttributes;
import org.codehaus.marmalade.model.MarmaladeTag;
import org.codehaus.marmalade.runtime.MarmaladeExecutionContext;
import org.codehaus.marmalade.runtime.MarmaladeExecutionException;
import org.codehaus.marmalade.runtime.TagExecutionException;
import org.codehaus.marmalade.tags.AbstractPassThroughTag;
import org.xml.sax.Attributes;

public class JellyCompatMarmaladeTag
extends AbstractPassThroughTag {
    private Tag jellyTag;
    private final JellyCompatMarmaladeTaglib marmaladeTaglib;

    public JellyCompatMarmaladeTag(JellyCompatMarmaladeTaglib marmaladeTaglib) {
        this.marmaladeTaglib = marmaladeTaglib;
    }

    protected void doExecute(MarmaladeExecutionContext context) throws MarmaladeExecutionException {
        try {
            MarmaladeTagInfo mti = this.getTagInfo();
            MarmaladeAttributes attributes = this.getAttributes();
            SAXAttributesWrapper attrs = new SAXAttributesWrapper(attributes);
            TagLibrary tagLibrary = this.marmaladeTaglib.getTagLibrary(mti.getTaglib());
            this.jellyTag = tagLibrary.createTag(mti.getElement(), (Attributes)attrs);
            if (this.jellyTag == null) {
                super.doExecute(context);
            } else {
                MarmaladeTag parent;
                ExpressionEvaluator el = this.getExpressionEvaluator();
                if (attributes != null) {
                    Iterator it = attributes.iterator();
                    while (it.hasNext()) {
                        MarmaladeAttribute attribute = (MarmaladeAttribute)it.next();
                        String name = attribute.getName();
                        Object value = attribute.getValue(context);
                        try {
                            el.assign((Object)this.jellyTag, name, value);
                        }
                        catch (ExpressionEvaluationException e) {
                            MarmaladeCompatJellyExpression expr = new MarmaladeCompatJellyExpression(value);
                            try {
                                el.assign((Object)this.jellyTag, name, (Object)expr);
                            }
                            catch (ExpressionEvaluationException eInner) {
                                if (!(this.jellyTag instanceof DynaTag)) continue;
                                ((DynaTag)this.jellyTag).setAttribute(name, value);
                            }
                        }
                        catch (Throwable e) {
                            throw new JellyCompatUncheckedException("Failed to assign attribute [ns=" + attribute.getNamespace() + ", prefix=" + attribute.getPrefix() + ", name=" + attribute.getName() + ", " + attribute.getRawValue() + "]", e);
                        }
                    }
                }
                if ((parent = this.getParent()) != null && parent instanceof JellyCompatMarmaladeTag) {
                    JellyCompatMarmaladeTag jellyMmldParent = (JellyCompatMarmaladeTag)parent;
                    this.jellyTag.setParent(jellyMmldParent.getJellyTag());
                }
                List childComponents = this.getChildComponents();
                ArrayList bodyItems = new ArrayList();
                Iterator it = childComponents.iterator();
                while (it.hasNext()) {
                    bodyItems.add(it.next());
                }
                MarmaladeCompatJellyContext jellyCtx = new MarmaladeCompatJellyContext(context, el, this.marmaladeTaglib);
                this.jellyTag.setContext((JellyContext)jellyCtx);
                XMLOutput output = (XMLOutput)context.getVariable((Object)"$$jelly-output$$", null);
                if (output == null) {
                    output = XMLOutput.createXMLOutput((Writer)context.getOutWriter());
                    context.setVariable((Object)"$$jelly-output$$", (Object)output);
                }
                MarmaladeCompatBodyScript body = new MarmaladeCompatBodyScript(this, context, el, bodyItems);
                this.jellyTag.setBody((Script)body);
                this.jellyTag.doTag(output);
            }
        }
        catch (JellyException e) {
            throw new TagExecutionException(this.getTagInfo(), "Error executing jelly tag.", (Throwable)e);
        }
        catch (JellyCompatUncheckedException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new TagExecutionException(this.getTagInfo(), "Error executing jelly tag.", cause);
        }
    }

    public Tag getJellyTag() {
        return this.jellyTag;
    }

    protected void doReset() {
        this.jellyTag = null;
    }

    public String formatWhitespace(String src, MarmaladeExecutionContext context) throws ExpressionEvaluationException {
        return super.formatWhitespace(src, context);
    }

    protected boolean mapChildren() {
        return true;
    }

    protected boolean alwaysProcessChildren() {
        return false;
    }

    public String toString() {
        return "Jelly-compatible tag@" + ((Object)((Object)this)).hashCode() + " [wrapping: " + (this.jellyTag == null ? "unresolved" : String.valueOf(this.jellyTag)) + "]";
    }
}

