/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.api.api;

import com.mailslurp.client.ApiCallback;
import com.mailslurp.client.ApiClient;
import com.mailslurp.client.ApiException;
import com.mailslurp.client.ApiResponse;
import com.mailslurp.client.Configuration;
import com.mailslurp.client.Pair;
import com.mailslurp.client.ProgressRequestBody;
import com.mailslurp.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mailslurp.models.Email;
import com.mailslurp.models.EmailPreview;
import com.mailslurp.models.MatchOptions;
import java.util.UUID;
import com.mailslurp.models.WaitForConditions;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WaitForControllerApi {
    private ApiClient localVarApiClient;

    public WaitForControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WaitForControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for waitFor
     * @param waitForConditions Conditions to wait for (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForCall(WaitForConditions waitForConditions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = waitForConditions;

        // create path and map variables
        String localVarPath = "/waitFor";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call waitForValidateBeforeCall(WaitForConditions waitForConditions, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = waitForCall(waitForConditions, _callback);
        return localVarCall;

    }

    /**
     * Wait for conditions to be met
     * Generic waitFor method that will wait until an inbox meets given conditions or return immediately if already met
     * @param waitForConditions Conditions to wait for (optional)
     * @return List&lt;EmailPreview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public List<EmailPreview> waitFor(WaitForConditions waitForConditions) throws ApiException {
        ApiResponse<List<EmailPreview>> localVarResp = waitForWithHttpInfo(waitForConditions);
        return localVarResp.getData();
    }

    /**
     * Wait for conditions to be met
     * Generic waitFor method that will wait until an inbox meets given conditions or return immediately if already met
     * @param waitForConditions Conditions to wait for (optional)
     * @return ApiResponse&lt;List&lt;EmailPreview&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<EmailPreview>> waitForWithHttpInfo(WaitForConditions waitForConditions) throws ApiException {
        okhttp3.Call localVarCall = waitForValidateBeforeCall(waitForConditions, null);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Wait for conditions to be met (asynchronously)
     * Generic waitFor method that will wait until an inbox meets given conditions or return immediately if already met
     * @param waitForConditions Conditions to wait for (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForAsync(WaitForConditions waitForConditions, final ApiCallback<List<EmailPreview>> _callback) throws ApiException {

        okhttp3.Call localVarCall = waitForValidateBeforeCall(waitForConditions, _callback);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for waitForEmailCount
     * @param count Number of emails to wait for. Must be greater that 1 (optional)
     * @param inboxId Id of the inbox we are fetching emails from (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForEmailCountCall(Integer count, UUID inboxId, Long timeout, Boolean unreadOnly, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/waitForEmailCount";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (count != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("count", count));
        }

        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        if (timeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeout", timeout));
        }

        if (unreadOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unreadOnly", unreadOnly));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call waitForEmailCountValidateBeforeCall(Integer count, UUID inboxId, Long timeout, Boolean unreadOnly, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = waitForEmailCountCall(count, inboxId, timeout, unreadOnly, _callback);
        return localVarCall;

    }

    /**
     * Wait for and return count number of emails 
     * If inbox contains count or more emails at time of request then return count worth of emails. If not wait until the count is reached and return those or return an error if timeout is exceeded.
     * @param count Number of emails to wait for. Must be greater that 1 (optional)
     * @param inboxId Id of the inbox we are fetching emails from (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @return List&lt;EmailPreview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public List<EmailPreview> waitForEmailCount(Integer count, UUID inboxId, Long timeout, Boolean unreadOnly) throws ApiException {
        ApiResponse<List<EmailPreview>> localVarResp = waitForEmailCountWithHttpInfo(count, inboxId, timeout, unreadOnly);
        return localVarResp.getData();
    }

    /**
     * Wait for and return count number of emails 
     * If inbox contains count or more emails at time of request then return count worth of emails. If not wait until the count is reached and return those or return an error if timeout is exceeded.
     * @param count Number of emails to wait for. Must be greater that 1 (optional)
     * @param inboxId Id of the inbox we are fetching emails from (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @return ApiResponse&lt;List&lt;EmailPreview&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<EmailPreview>> waitForEmailCountWithHttpInfo(Integer count, UUID inboxId, Long timeout, Boolean unreadOnly) throws ApiException {
        okhttp3.Call localVarCall = waitForEmailCountValidateBeforeCall(count, inboxId, timeout, unreadOnly, null);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Wait for and return count number of emails  (asynchronously)
     * If inbox contains count or more emails at time of request then return count worth of emails. If not wait until the count is reached and return those or return an error if timeout is exceeded.
     * @param count Number of emails to wait for. Must be greater that 1 (optional)
     * @param inboxId Id of the inbox we are fetching emails from (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForEmailCountAsync(Integer count, UUID inboxId, Long timeout, Boolean unreadOnly, final ApiCallback<List<EmailPreview>> _callback) throws ApiException {

        okhttp3.Call localVarCall = waitForEmailCountValidateBeforeCall(count, inboxId, timeout, unreadOnly, _callback);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for waitForLatestEmail
     * @param inboxId Id of the inbox we are fetching emails from (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only. (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForLatestEmailCall(UUID inboxId, Long timeout, Boolean unreadOnly, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/waitForLatestEmail";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        if (timeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeout", timeout));
        }

        if (unreadOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unreadOnly", unreadOnly));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call waitForLatestEmailValidateBeforeCall(UUID inboxId, Long timeout, Boolean unreadOnly, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = waitForLatestEmailCall(inboxId, timeout, unreadOnly, _callback);
        return localVarCall;

    }

    /**
     * Fetch inbox&#39;s latest email or if empty wait for an email to arrive
     * Will return either the last received email or wait for an email to arrive and return that. If you need to wait for an email for a non-empty inbox set &#x60;unreadOnly&#x3D;true&#x60; or see the other receive methods such as &#x60;waitForNthEmail&#x60; or &#x60;waitForEmailCount&#x60;.
     * @param inboxId Id of the inbox we are fetching emails from (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only. (optional, default to false)
     * @return Email
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public Email waitForLatestEmail(UUID inboxId, Long timeout, Boolean unreadOnly) throws ApiException {
        ApiResponse<Email> localVarResp = waitForLatestEmailWithHttpInfo(inboxId, timeout, unreadOnly);
        return localVarResp.getData();
    }

    /**
     * Fetch inbox&#39;s latest email or if empty wait for an email to arrive
     * Will return either the last received email or wait for an email to arrive and return that. If you need to wait for an email for a non-empty inbox set &#x60;unreadOnly&#x3D;true&#x60; or see the other receive methods such as &#x60;waitForNthEmail&#x60; or &#x60;waitForEmailCount&#x60;.
     * @param inboxId Id of the inbox we are fetching emails from (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only. (optional, default to false)
     * @return ApiResponse&lt;Email&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Email> waitForLatestEmailWithHttpInfo(UUID inboxId, Long timeout, Boolean unreadOnly) throws ApiException {
        okhttp3.Call localVarCall = waitForLatestEmailValidateBeforeCall(inboxId, timeout, unreadOnly, null);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Fetch inbox&#39;s latest email or if empty wait for an email to arrive (asynchronously)
     * Will return either the last received email or wait for an email to arrive and return that. If you need to wait for an email for a non-empty inbox set &#x60;unreadOnly&#x3D;true&#x60; or see the other receive methods such as &#x60;waitForNthEmail&#x60; or &#x60;waitForEmailCount&#x60;.
     * @param inboxId Id of the inbox we are fetching emails from (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only. (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForLatestEmailAsync(UUID inboxId, Long timeout, Boolean unreadOnly, final ApiCallback<Email> _callback) throws ApiException {

        okhttp3.Call localVarCall = waitForLatestEmailValidateBeforeCall(inboxId, timeout, unreadOnly, _callback);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for waitForMatchingEmail
     * @param matchOptions matchOptions (required)
     * @param count Number of emails to wait for. Must be greater that 1 (optional)
     * @param inboxId Id of the inbox we are fetching emails from (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForMatchingEmailCall(MatchOptions matchOptions, Integer count, UUID inboxId, Long timeout, Boolean unreadOnly, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = matchOptions;

        // create path and map variables
        String localVarPath = "/waitForMatchingEmails";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (count != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("count", count));
        }

        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        if (timeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeout", timeout));
        }

        if (unreadOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unreadOnly", unreadOnly));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call waitForMatchingEmailValidateBeforeCall(MatchOptions matchOptions, Integer count, UUID inboxId, Long timeout, Boolean unreadOnly, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'matchOptions' is set
        if (matchOptions == null) {
            throw new ApiException("Missing the required parameter 'matchOptions' when calling waitForMatchingEmail(Async)");
        }
        

        okhttp3.Call localVarCall = waitForMatchingEmailCall(matchOptions, count, inboxId, timeout, unreadOnly, _callback);
        return localVarCall;

    }

    /**
     * Wait or return list of emails that match simple matching patterns
     * Perform a search of emails in an inbox with the given patterns. If results match expected count then return or else retry the search until results are found or timeout is reached. Match options allow simple CONTAINS or EQUALS filtering on SUBJECT, TO, BCC, CC, and FROM. See the &#x60;MatchOptions&#x60; object for options.
     * @param matchOptions matchOptions (required)
     * @param count Number of emails to wait for. Must be greater that 1 (optional)
     * @param inboxId Id of the inbox we are fetching emails from (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @return List&lt;EmailPreview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public List<EmailPreview> waitForMatchingEmail(MatchOptions matchOptions, Integer count, UUID inboxId, Long timeout, Boolean unreadOnly) throws ApiException {
        ApiResponse<List<EmailPreview>> localVarResp = waitForMatchingEmailWithHttpInfo(matchOptions, count, inboxId, timeout, unreadOnly);
        return localVarResp.getData();
    }

    /**
     * Wait or return list of emails that match simple matching patterns
     * Perform a search of emails in an inbox with the given patterns. If results match expected count then return or else retry the search until results are found or timeout is reached. Match options allow simple CONTAINS or EQUALS filtering on SUBJECT, TO, BCC, CC, and FROM. See the &#x60;MatchOptions&#x60; object for options.
     * @param matchOptions matchOptions (required)
     * @param count Number of emails to wait for. Must be greater that 1 (optional)
     * @param inboxId Id of the inbox we are fetching emails from (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @return ApiResponse&lt;List&lt;EmailPreview&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<EmailPreview>> waitForMatchingEmailWithHttpInfo(MatchOptions matchOptions, Integer count, UUID inboxId, Long timeout, Boolean unreadOnly) throws ApiException {
        okhttp3.Call localVarCall = waitForMatchingEmailValidateBeforeCall(matchOptions, count, inboxId, timeout, unreadOnly, null);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Wait or return list of emails that match simple matching patterns (asynchronously)
     * Perform a search of emails in an inbox with the given patterns. If results match expected count then return or else retry the search until results are found or timeout is reached. Match options allow simple CONTAINS or EQUALS filtering on SUBJECT, TO, BCC, CC, and FROM. See the &#x60;MatchOptions&#x60; object for options.
     * @param matchOptions matchOptions (required)
     * @param count Number of emails to wait for. Must be greater that 1 (optional)
     * @param inboxId Id of the inbox we are fetching emails from (optional)
     * @param timeout Max milliseconds to wait (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForMatchingEmailAsync(MatchOptions matchOptions, Integer count, UUID inboxId, Long timeout, Boolean unreadOnly, final ApiCallback<List<EmailPreview>> _callback) throws ApiException {

        okhttp3.Call localVarCall = waitForMatchingEmailValidateBeforeCall(matchOptions, count, inboxId, timeout, unreadOnly, _callback);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for waitForNthEmail
     * @param inboxId Id of the inbox you are fetching emails from (optional)
     * @param index Zero based index of the email to wait for. If an inbox has 1 email already and you want to wait for the 2nd email pass index&#x3D;1 (optional, default to 0)
     * @param timeout Max milliseconds to wait for the nth email if not already present (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForNthEmailCall(UUID inboxId, Integer index, Long timeout, Boolean unreadOnly, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/waitForNthEmail";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        if (index != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("index", index));
        }

        if (timeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeout", timeout));
        }

        if (unreadOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unreadOnly", unreadOnly));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call waitForNthEmailValidateBeforeCall(UUID inboxId, Integer index, Long timeout, Boolean unreadOnly, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = waitForNthEmailCall(inboxId, index, timeout, unreadOnly, _callback);
        return localVarCall;

    }

    /**
     * Wait for or fetch the email with a given index in the inbox specified
     * If nth email is already present in inbox then return it. If not hold the connection open until timeout expires or the nth email is received and returned.
     * @param inboxId Id of the inbox you are fetching emails from (optional)
     * @param index Zero based index of the email to wait for. If an inbox has 1 email already and you want to wait for the 2nd email pass index&#x3D;1 (optional, default to 0)
     * @param timeout Max milliseconds to wait for the nth email if not already present (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @return Email
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public Email waitForNthEmail(UUID inboxId, Integer index, Long timeout, Boolean unreadOnly) throws ApiException {
        ApiResponse<Email> localVarResp = waitForNthEmailWithHttpInfo(inboxId, index, timeout, unreadOnly);
        return localVarResp.getData();
    }

    /**
     * Wait for or fetch the email with a given index in the inbox specified
     * If nth email is already present in inbox then return it. If not hold the connection open until timeout expires or the nth email is received and returned.
     * @param inboxId Id of the inbox you are fetching emails from (optional)
     * @param index Zero based index of the email to wait for. If an inbox has 1 email already and you want to wait for the 2nd email pass index&#x3D;1 (optional, default to 0)
     * @param timeout Max milliseconds to wait for the nth email if not already present (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @return ApiResponse&lt;Email&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Email> waitForNthEmailWithHttpInfo(UUID inboxId, Integer index, Long timeout, Boolean unreadOnly) throws ApiException {
        okhttp3.Call localVarCall = waitForNthEmailValidateBeforeCall(inboxId, index, timeout, unreadOnly, null);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Wait for or fetch the email with a given index in the inbox specified (asynchronously)
     * If nth email is already present in inbox then return it. If not hold the connection open until timeout expires or the nth email is received and returned.
     * @param inboxId Id of the inbox you are fetching emails from (optional)
     * @param index Zero based index of the email to wait for. If an inbox has 1 email already and you want to wait for the 2nd email pass index&#x3D;1 (optional, default to 0)
     * @param timeout Max milliseconds to wait for the nth email if not already present (optional)
     * @param unreadOnly Optional filter for unread only (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call waitForNthEmailAsync(UUID inboxId, Integer index, Long timeout, Boolean unreadOnly, final ApiCallback<Email> _callback) throws ApiException {

        okhttp3.Call localVarCall = waitForNthEmailValidateBeforeCall(inboxId, index, timeout, unreadOnly, _callback);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
