/*
 * Decompiled with CFR 0.152.
 */
package com.lightningkite.kotlin.collection;

import com.lightningkite.kotlin.collection.LkKotlinUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010)\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u0003B;\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u001c\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u001fH\u0096\u0002J\u0015\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010!\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u0018H\u0016J\u0016\u0010\"\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u0018H\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/lightningkite/kotlin/collection/MappedMutableSet;", "S", "E", "", "source", "mapper", "Lkotlin/Function1;", "reverseMapper", "(Ljava/util/Set;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getMapper", "()Lkotlin/jvm/functions/Function1;", "getReverseMapper", "size", "", "getSize", "()I", "getSource", "()Ljava/util/Set;", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "isEmpty", "iterator", "", "remove", "removeAll", "retainAll", "lk-kotlin-utils"})
public final class MappedMutableSet<S, E>
implements Set<E>,
KMutableSet {
    @NotNull
    private final Set<S> source;
    @NotNull
    private final Function1<S, E> mapper;
    @NotNull
    private final Function1<E, S> reverseMapper;

    public int getSize() {
        return this.source.size();
    }

    @Override
    public boolean add(E element) {
        return this.source.add(this.reverseMapper.invoke(element));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(@NotNull Collection<? extends E> elements) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Iterable iterable = elements;
        Function1<E, S> function1 = this.reverseMapper;
        Set<S> set = this.source;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void transform$iv;
            destination$iv$iv.add(transform$iv.invoke(item$iv$iv));
        }
        List list = (List)destination$iv$iv;
        return set.addAll(list);
    }

    @Override
    public void clear() {
        this.source.clear();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return LkKotlinUtils.mapping(this.source.iterator(), this.mapper, this.reverseMapper);
    }

    @Override
    public boolean remove(Object element) {
        return this.source.remove(this.reverseMapper.invoke(element));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Iterable iterable = elements;
        Function1<E, S> function1 = this.reverseMapper;
        Set<S> set = this.source;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void transform$iv;
            destination$iv$iv.add(transform$iv.invoke(item$iv$iv));
        }
        List list = (List)destination$iv$iv;
        return set.removeAll(list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Iterable iterable = elements;
        Function1<E, S> function1 = this.reverseMapper;
        Set<S> set = this.source;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void transform$iv;
            destination$iv$iv.add(transform$iv.invoke(item$iv$iv));
        }
        List list = (List)destination$iv$iv;
        return set.retainAll(list);
    }

    @Override
    public boolean contains(Object element) {
        return this.source.contains(this.reverseMapper.invoke(element));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Iterable iterable = elements;
        Function1<E, S> function1 = this.reverseMapper;
        Set<S> set = this.source;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void transform$iv;
            destination$iv$iv.add(transform$iv.invoke(item$iv$iv));
        }
        List list = (List)destination$iv$iv;
        return set.containsAll(list);
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @NotNull
    public final Set<S> getSource() {
        return this.source;
    }

    @NotNull
    public final Function1<S, E> getMapper() {
        return this.mapper;
    }

    @NotNull
    public final Function1<E, S> getReverseMapper() {
        return this.reverseMapper;
    }

    public MappedMutableSet(@NotNull Set<S> source, @NotNull Function1<? super S, ? extends E> mapper, @NotNull Function1<? super E, ? extends S> reverseMapper) {
        Intrinsics.checkParameterIsNotNull(source, (String)"source");
        Intrinsics.checkParameterIsNotNull(mapper, (String)"mapper");
        Intrinsics.checkParameterIsNotNull(reverseMapper, (String)"reverseMapper");
        this.source = source;
        this.mapper = mapper;
        this.reverseMapper = reverseMapper;
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return CollectionToArray.toArray((Collection)this, (Object[])TArray);
    }
}

