(ns {{name}}.core
  (:require [live-static.state :as state]
            [live-static.component :as component]
            [live-static.dom :as dom]))

(defn {{name}}-app [app-state]
  [:div
   [:h1 "Hello " (:name app-state)]
   [:button#greet-jane "Greet Jane!"]
   [:button#greet-bob "Greet Bob!"]
   [:button#greeting "Greet the world!"]])

(defn {{name}}-events [app-state]
  [["button#greeting"   :click (fn [] (state/update {:name "World"} app-state))]
   ["button#greet-jane" :click (fn [] (state/update {:name "Jane"} app-state))]
   ["button#greet-bob"  :click (fn [] (state/update {:name "Bob"} app-state))]])

(def initial-app-state
  {:name "World"})

(component/render {{name}}-app
                  :events {{name}}-events
                  :app-state initial-app-state
                  :target "app")
