(ns leiningen.new.live-static-app
  (:require [leiningen.new.templates :refer [renderer sanitize name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "live-static-app"))

(defn live-static-app [name]
  (let [data {:name name
              :sanitized (sanitize name)}
        render #((renderer "live-static-app") % data)]

    (main/info "Generating new live-static project...")

    (->files data
             "resources/public/"
             (str "src/cljs/" (:sanitized data))
             ["resources/public/app.css"                   (render "app.css")]
             ["resources/public/index.html"                (render "index.html")]
             ["resources/public/index_bs3.html"            (render "index_bs3.html")]
             [(str "src/cljs/" (:sanitized data) "/core.cljs") (render "core.cljs")]
             ["project.clj"                                (render "project.clj")]
             ["README.md"                                  (render "README.clj")])))
