package litifer.com.sdk.presentation.ui.activities;

import android.Manifest;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;

import litifer.com.sdk.R;
import litifer.com.sdk.presentation.Litifer;

public class LitiferManagerActivity extends AppCompatActivity{
    private String TAG = "Activity";
    private Litifer litifer;

    private int PERMISSION_REQUEST_COARSE_LOCATION;
    private int PERMISSION_REQUEST_GET_ACCOUNTS;
    private static final int REQUEST_RESOLVE_ERROR = 1001;
    @Override
    protected void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_litifer_manager);

        litifer = Litifer.init(this);
        litifer.addCustomer()
                .setAge(23)
                .setName("dipu")
                .setEmail("rit2012015dipu@gmail.com")
                .setGender("male")
                .setPhone_no("9818252130");

        litifer.config()
                .setApplicationID("592ff8126acd4a048a5deaa4")
                .setApplicationSecret("946ef7fe-fc99-43a2-87ce-1d526cbc2978")
                .enableBackGroundMonitoring();



        litifer.saveConfig(new Litifer.SaveConfigListener() {
            @Override
            public void onSuccess(String message) {

            }

            @Override
            public void onFailure(String errorMessage) {

            }
        });

//        litifer.scanWiFiDevice(1100,100);

        litifer.startMonitoringWifi();


        startLitiferMonitoring(new Litifer.MonitoringListener() {
            @Override
            public void onSuccess(String message) {

            }

            @Override
            public void onFailure() {

            }
        });
    }

        public void startLitiferMonitoring(Litifer.MonitoringListener monitoringListener) {
            if (Build.VERSION.SDK_INT >= 23) {
                // Marshmallow+
                if (ContextCompat.checkSelfPermission(getApplicationContext(), Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                    requestPermissions(new String[]{Manifest.permission.ACCESS_FINE_LOCATION}, 0);
                } else {
                    litifer.startMonitoring(monitoringListener);
                }
            } else {
                // Pre-Marshmallow
                litifer.startMonitoring(monitoringListener);
            }
        }

        @Override
        public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
            if (requestCode == 0) {
                if (grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    litifer.startMonitoring(null);
                }
            } else {
                super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            }
        }


    @Override
    protected void onDestroy() {
        super.onDestroy();
        litifer.close();
    }
}
