package litifer.com.sdk.presentation.presenters.base;

import org.altbeacon.beacon.Region;

import java.io.Serializable;
import java.util.ArrayList;

import litifer.com.sdk.data.model.GeofenceEntity;
import litifer.com.sdk.data.model.MessageEntity;
import litifer.com.sdk.presentation.ui.BaseView;

/**
 * Created by kishlaykishore on 08/03/17.
 */

public interface Delegates extends Serializable{

    interface ApiResponse {

        void deviceSetupResponse(String msg);
//        void advertisingId(AdvertisingIdClient.Info info);


        void fetchGeofencesFromServerResponse(String message);

        void fetchNotificationsFromServerResponse(String message);


    }

    interface BeaconRegistrationObserver{
        void beaconRegionsListener(ArrayList<Region> regions);
        void addBootstrapNotifierRegions(ArrayList<Region> regions);
    }


    interface BeaconsObserver {
        void onSuccess(String message);
        void onError(String errorMessage);
        void onDelete();
    }

    interface NotificationsObserver {
        void onSuccess(String message);
        void onError(String errorMessage);
    }

    interface GeofenceObserver {
        void onSuccess(String message);
        void onError(String errorMessage);
    }

    interface GeofenceRegistrationObserver {
//        void onRegisteredGeofences(ArrayList<Geofence> geofences);
    }

    interface GeofenceTransitionObserver {
        void onEnterGeofence(GeofenceEntity place);
        void onExitGeofence(GeofenceEntity place);
    }

    interface BeaconTransitionObserver {
        void onEnterBeaconRegion();
        void onDelayEventResponse();
        void onExitBeaconRegion();
    }

    interface NotificationDeliveryObserver{
        void onMessageReceived(MessageEntity message);
    }

    interface NotificationInteractionObserver{
        void onNotificationOpened(MessageEntity message);
        void onNotificationDeleted(MessageEntity message);
    }

    interface DeleteBeaconsObserver{
        void onSuccess(String message);
        void onError(String errorMessage);
    }

}
