package litifer.com.sdk.presentation.presenters.base;


import android.content.Context;

import litifer.com.sdk.presentation.subscriber.thread.PostExecutionThread;
import litifer.com.sdk.domain.executor.ThreadExecutor;

/**
 * Created by kishlaykishore on 07/03/17.
 * This is a base class for all presenters which are communicating with interactors. This base class will hold a
 * reference to the Executor and MainThread objects that are needed for running interactors in a background thread.
 */

public abstract class AbstractPresenter {
    protected ThreadExecutor   mExecutor;
    protected PostExecutionThread mPostExecutionThread;
    protected Context mContext;

    public AbstractPresenter(ThreadExecutor executor, PostExecutionThread postExecutionThread, Context context) {
        mExecutor = executor;
        mPostExecutionThread = postExecutionThread;
        mContext=context;
    }
}
