package litifer.com.sdk.presentation.presenters;

import android.content.Context;
import android.util.Log;
import litifer.com.sdk.data.model.WifiEntity;
import litifer.com.sdk.domain.executor.ThreadExecutor;
import litifer.com.sdk.domain.interactors.EnterWifiRegionInteractor;
import litifer.com.sdk.domain.interactors.ExitWifiRegionInteractor;
import litifer.com.sdk.domain.interactors.TimedWifiEventsInteractor;
import litifer.com.sdk.presentation.Litifer;
import litifer.com.sdk.presentation.presenters.base.AbstractPresenter;
import litifer.com.sdk.presentation.subscriber.DefaultSubscriber;
import litifer.com.sdk.presentation.subscriber.thread.PostExecutionThread;

/**
 * Created by kishlaykishore on 07/06/17.
 */

public class WifiServicePresenter extends AbstractPresenter {
    private String TAG="BeaconServicePresenter";
    static Litifer.MonitoringListener monitoringListener;
    int count =0;
    public WifiServicePresenter(ThreadExecutor executor, PostExecutionThread postExecutionThread, Context context) {

        super(executor,postExecutionThread,context);
    }
    public void setListener(Litifer.MonitoringListener listener){
        this.monitoringListener=listener;
    }

    public void enterEvent(WifiEntity wifiEntity) {

        new EnterWifiRegionInteractor(mExecutor,mPostExecutionThread,mContext,wifiEntity).execute(new WifiEventSubscriber());
    }


    public void exitEvent(WifiEntity wifiEntity, long time) {
        new ExitWifiRegionInteractor(mExecutor,mPostExecutionThread,mContext,wifiEntity,time).execute(new WifiEventSubscriber());
    }

    public void delayEvent(WifiEntity wifiEntity,long time){
        new TimedWifiEventsInteractor(mExecutor,mPostExecutionThread,mContext,wifiEntity,time).execute(new WifiEventSubscriber());
    }

    private final class WifiEventSubscriber extends DefaultSubscriber<String> {


        @Override
        public void onCompleted() {

        }

        @Override
        public void onError(Throwable e) {
            Log.d("Error/EnterRegion",e.getMessage());
        }

        @Override public void onNext(String message) {

            Log.d("wifiResponse",message);
            monitoringListener.onSuccess(message);
        }
    }
}
