package litifer.com.sdk.presentation.presenters;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.RingtoneManager;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import android.util.Log;

import com.google.gson.Gson;

import java.util.Map;

import litifer.com.sdk.data.model.BigText;
import litifer.com.sdk.data.model.FcmDataFieldsEntity;
import litifer.com.sdk.data.model.ImageStyle;
import litifer.com.sdk.data.model.Inbox;
import litifer.com.sdk.data.model.NotificationEntity;
import litifer.com.sdk.data.model.NotificationTypeEntity;
import litifer.com.sdk.domain.executor.ThreadExecutor;
import litifer.com.sdk.domain.interactors.ReceiveNotificationInteractor;
import litifer.com.sdk.presentation.presenters.base.AbstractPresenter;
import litifer.com.sdk.presentation.presenters.base.Delegates;
import litifer.com.sdk.presentation.subscriber.thread.PostExecutionThread;

/**
 * Created by kishlaykishore on 12/04/17.
 */

public class ReceiveNotificationPresenter extends AbstractPresenter{

    private String TAG = "RNPresenter";

    private Delegates.NotificationDeliveryObserver notificationDeliveryObserver;

    public ReceiveNotificationPresenter(ThreadExecutor executor, PostExecutionThread postExecutionThread, Delegates.NotificationDeliveryObserver notificationDeliveryObserver, Context context) {
        super(executor, postExecutionThread,context);
        this.notificationDeliveryObserver = notificationDeliveryObserver;
    }

    public void receiveFcmMessage(Map<String,String> remoteMessage){
        Bitmap image = null;
//        if (remoteMessage.getData().containsKey("image")){
//            image = getBitmapfromUrl(remoteMessage.getData().get("image"));
//        }

        NotificationCompat.Style abstractStyle = null;

        if(remoteMessage.get(FcmDataFieldsEntity.TYPE) != null) {
            if (remoteMessage.get(FcmDataFieldsEntity.TYPE).equals(NotificationTypeEntity.INBOX.toString())) {

                Inbox inbox = new Gson().fromJson(remoteMessage.get(FcmDataFieldsEntity.INBOX), Inbox.class);
                abstractStyle = NotificationEntity.InboxStyle.getStyle(inbox.getTitle(), inbox.getOffers(), inbox.getSummary());
                remoteMessage.remove(FcmDataFieldsEntity.INBOX);

            } else if (remoteMessage.get(FcmDataFieldsEntity.TYPE).equals(NotificationTypeEntity.IMAGE.toString())) {

                ImageStyle imageStyle = new Gson().fromJson(remoteMessage.get(FcmDataFieldsEntity.IMAGESTYLE), ImageStyle.class);
                abstractStyle = NotificationEntity.BigPictureStyle.getStyle(imageStyle.getImg(), imageStyle.getTitle(), imageStyle.getSummary());
                remoteMessage.remove(FcmDataFieldsEntity.IMAGESTYLE);

            } else if (remoteMessage.get(FcmDataFieldsEntity.TYPE).equals(NotificationTypeEntity.BIGTEXT.toString())) {

                BigText bigText = new Gson().fromJson(remoteMessage.get(FcmDataFieldsEntity.BIGTEXT), BigText.class);
                abstractStyle = NotificationEntity.BigTextStyle.getStyle(bigText.getMessage(), bigText.getTitle(), bigText.getSummary());
                remoteMessage.remove(FcmDataFieldsEntity.BIGTEXT);

            } else if (remoteMessage.get(FcmDataFieldsEntity.TYPE).equals(NotificationTypeEntity.NORMAL.toString())) {
                abstractStyle=null;
            }
        } else{
            Log.d(TAG,"to-do when normal notification");
        }
        //call a presenter to save this in realm.
//        NotificationTemplateEntity notificationTemplateEntity = new NotificationMapToJsonMapper().transformMapToNotificationModel(remoteMessage.getData());

        Bitmap largeIcon = (remoteMessage.get(FcmDataFieldsEntity.LARGEICON) == null) ? null: NotificationEntity.BigPictureStyle.getBitmapfromUrl(remoteMessage.get(FcmDataFieldsEntity.LARGEICON));
        Uri audioTrack = (remoteMessage.get("audio") == null) ? null : RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);

        String notification_id = remoteMessage.get("_id");

        new ReceiveNotificationInteractor(mExecutor, mPostExecutionThread,mContext).deliverNotification(remoteMessage.get(FcmDataFieldsEntity.NAME),remoteMessage.get(FcmDataFieldsEntity.DESCRIPTION),null,largeIcon,abstractStyle,audioTrack,notification_id);
    }
}
