package litifer.com.sdk.presentation.presenters;

import android.content.Context;
import android.util.Log;

import java.util.ArrayList;
import java.util.List;

import litifer.com.sdk.data.model.GeofenceEntity;
import litifer.com.sdk.data.model.NotificationTemplateEntity;
import litifer.com.sdk.domain.executor.ThreadExecutor;
import litifer.com.sdk.domain.interactors.FetchGeofenceInterator;
import litifer.com.sdk.domain.interactors.FetchInboxInteractor;
import litifer.com.sdk.domain.interactors.RegisterOnServerInteractor;
import litifer.com.sdk.presentation.Litifer;
import litifer.com.sdk.presentation.presenters.base.AbstractPresenter;
import litifer.com.sdk.presentation.presenters.base.Delegates;
import litifer.com.sdk.presentation.subscriber.DefaultSubscriber;
import litifer.com.sdk.presentation.subscriber.thread.PostExecutionThread;

/**
 * Created by kishlaykishore on 11/04/17.
 */

public class LitiferManagerPresenter extends AbstractPresenter{
    Delegates.ApiResponse mView;
    Litifer.SaveConfigListener saveConfigListener;
    private Delegates.BeaconsObserver beaconsObserver;
    private Litifer.InboxListener inboxListener;
    private Litifer.GeofenceListener geofenceListener;
    public LitiferManagerPresenter(ThreadExecutor executor, PostExecutionThread postExecutionThread, Context context){
        super(executor,postExecutionThread,context);

    }

    public void register(Litifer.SaveConfigListener saveConfigListener) {
        this.saveConfigListener=saveConfigListener;
        new RegisterOnServerInteractor(mExecutor,mPostExecutionThread,mContext).execute(new RegisterSubscriber());
    }

    public void fetchInboxContent(Litifer.InboxListener listener){
        inboxListener = listener;
        new FetchInboxInteractor(mExecutor,mPostExecutionThread,mContext).execute(new FetchInboxSubscriber());
    }

    public void fetchGeofences(Litifer.GeofenceListener listener,double lat, double lon){
        geofenceListener=listener;
        new FetchGeofenceInterator(mExecutor,mPostExecutionThread, mContext,lat,lon).execute(new FetchGeofenceSubscriber());
    }

    private final class RegisterSubscriber extends DefaultSubscriber<String> {

        @Override
        public void onCompleted() {

        }

        @Override
        public void onError(Throwable e) {

            Log.d("Error/Register",e.getMessage());
            saveConfigListener.onFailure(e.getMessage());
        }

        @Override public void onNext(String message) {
            saveConfigListener.onSuccess(message);
            //to-do
        }
    }

    private final class AddRegionSubscriber extends DefaultSubscriber<String> {

        @Override
        public void onCompleted() {
            beaconsObserver.onSuccess("");
        }

        @Override
        public void onError(Throwable e) {

            Log.d("Error/FetchBeacons",e.getMessage());
            beaconsObserver.onError(e.getMessage());
        }


        @Override public void onNext(String message) {
            beaconsObserver.onSuccess(message);
        }
    }


    private final class FetchInboxSubscriber extends DefaultSubscriber<ArrayList<NotificationTemplateEntity>> {

        @Override
        public void onCompleted() {
//            beaconsObserver.onSuccess("");
        }

        @Override
        public void onError(Throwable e) {

            Log.d("Error/FetchBeacons",e.getMessage());
            inboxListener.onFailure(e.getMessage());
        }


        @Override
        public void onNext(ArrayList<NotificationTemplateEntity> notifications) {
            inboxListener.onSuccess(notifications);
        }
    }

    private final class FetchGeofenceSubscriber extends DefaultSubscriber<List<GeofenceEntity>> {

        @Override
        public void onCompleted() {
//            beaconsObserver.onSuccess("");
        }

        @Override
        public void onError(Throwable e) {

            Log.d("Error/FetchBeacons",e.getMessage());
            geofenceListener.onFailure(e.getMessage());
        }


        @Override
        public void onNext(List<GeofenceEntity> geofenceEntities) {
            geofenceListener.onSuccess(geofenceEntities);
        }
    }
}
