package litifer.com.sdk.presentation.presenters;

import android.content.Context;
import android.util.Log;
import android.widget.Toast;

import litifer.com.sdk.domain.executor.ThreadExecutor;
import litifer.com.sdk.domain.interactors.GeofenceRegionInteractor;
import litifer.com.sdk.domain.interactors.GeofenceRequestInteractor;
import litifer.com.sdk.presentation.presenters.base.AbstractPresenter;
import litifer.com.sdk.presentation.subscriber.DefaultSubscriber;
import litifer.com.sdk.presentation.subscriber.thread.PostExecutionThread;

/**
 * Created by kishlaykishore on 14/06/17.
 */

public class GeofenceRequestPresenter extends AbstractPresenter{

    public GeofenceRequestPresenter(ThreadExecutor executor, PostExecutionThread postExecutionThread, Context context) {
        super(executor, postExecutionThread, context);
    }

    public void fetchGeofences(double latitude, double longitude) {
        new GeofenceRequestInteractor(mExecutor,mPostExecutionThread,mContext,latitude,longitude).execute(new GeofireSubscriber());
    }
    public void Event(String id,String type){
        new GeofenceRegionInteractor(mExecutor,mPostExecutionThread,mContext,id,type).execute(new GeofireSubscriber());
    }
        private final class GeofireSubscriber extends DefaultSubscriber<String> {

        @Override
        public void onCompleted() {

        }

        @Override
        public void onError(Throwable e) {

            Log.d("Error/GeofenceRequests",e.getMessage());
        }

        @Override public void onNext(String message) {
            Log.d("geofenceResponse",message);

        }
    }
}
