package litifer.com.sdk.presentation.presenters;

import android.content.Context;
import android.util.Log;
import android.widget.Toast;

import org.altbeacon.beacon.Beacon;

import litifer.com.sdk.domain.executor.ThreadExecutor;
import litifer.com.sdk.domain.interactors.EnterBeaconRegionInteractor;
import litifer.com.sdk.domain.interactors.ExitBeaconRegionInteractor;
import litifer.com.sdk.domain.interactors.TimedBeaconEventsInteractor;
import litifer.com.sdk.presentation.presenters.base.AbstractPresenter;
import litifer.com.sdk.presentation.subscriber.DefaultSubscriber;
import litifer.com.sdk.presentation.subscriber.thread.PostExecutionThread;

/**
 * Created by dipu on 4/4/17.
 */

public class BeaconServicePresenter extends AbstractPresenter{
    private String TAG="BeaconServicePresenter";

    public BeaconServicePresenter(ThreadExecutor executor, PostExecutionThread postExecutionThread, Context context) {
        super(executor,postExecutionThread,context);
    }


    public void enterEvent(Beacon beacon) {
        new EnterBeaconRegionInteractor(mExecutor,mPostExecutionThread,mContext,beacon).execute(new BeaconEventSubscriber());
    }


    public void exitEvent(Beacon beacon, long time) {
        new ExitBeaconRegionInteractor(mExecutor,mPostExecutionThread,mContext,beacon,time).execute(new BeaconEventSubscriber());
    }

    public void delayEvent(Beacon beacon,long time){
        new TimedBeaconEventsInteractor(mExecutor,mPostExecutionThread,mContext,beacon,time).execute(new BeaconEventSubscriber());
    }


    private final class BeaconEventSubscriber extends DefaultSubscriber<String> {

        @Override
        public void onCompleted() {

        }

        @Override
        public void onError(Throwable e) {
            Log.d("Error/EnterRegion",e.getMessage());
        }

        @Override public void onNext(String message) {
            Log.d("beaconsResponse",message);

        }
    }
}