package litifer.com.sdk.presentation;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.wifi.WifiManager;
import android.util.Log;

/**
 * Created by kishlaykishore on 14/06/17.
 */

public class WifiStartReceiver extends BroadcastReceiver {

    private String TAG = "WifiStartReceiver";
    @Override
    public void onReceive(Context context, Intent intent) {

        // TODO: This method is called when the BroadcastReceiver is receiving
        // an Intent broadcast.
        //********** Basic validation **********
        if (intent == null) {
            Log.d(TAG,"Received null intent");
            return;
        }

        Log.d(TAG,"Intent Received."+intent.getAction());

        String intentAction = intent.getAction();
        if (intentAction == null) {
            Log.d(TAG, "Received intent without intent action string");
            return;
        }
        WifiManager wifi = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
        if (!wifi.isWifiEnabled()){
            Log.d(TAG,"wifi not enabled");
            context.stopService(new Intent(context,WifiService.class));
            return;
        }

        context.startService(new Intent(context,WifiService.class));
    }
}