package litifer.com.sdk.presentation;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.SystemClock;
import android.support.annotation.IntDef;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.Pair;


import org.altbeacon.beacon.BeaconManager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

import litifer.com.sdk.data.model.WifiEntity;
import litifer.com.sdk.domain.executor.impl.JobExecutor;
import litifer.com.sdk.presentation.presenters.WifiServicePresenter;
import litifer.com.sdk.presentation.subscriber.thread.UIThread;

/**
 * Created by kishlaykishore on 06/06/17.
 */

public class WifiService extends Service {
    private WiFiManager wiFiManager;
    private int DEFAULT_FOREGROUND_SCAN_PERIOD = 1100;
    private int DEFAULT_FOREGROUND_BETWEEN_SCAN_PERIOD = 100;
    private long stayUnitDuration;
    private WifiServicePresenter wifiServicePresenter;

    public enum TRIGGER{
        ENTRY(0),
        EXIT(5),
        TRIGGER_DURATION(60000);

        private int intValue;
        private TRIGGER(int intValue){
            this.intValue=intValue;
        }

    }

    HashMap<WifiEntity,Pair<Integer,Long>> mActiveWifiList=new HashMap<WifiEntity, Pair<Integer,Long>>();

    public WifiService(){
        super();
    }

    @Override
    public void onCreate() {

        super.onCreate();
        stayUnitDuration = BeaconManager.DEFAULT_FOREGROUND_BETWEEN_SCAN_PERIOD + BeaconManager.DEFAULT_FOREGROUND_SCAN_PERIOD;
        wifiServicePresenter =new WifiServicePresenter(new JobExecutor(), UIThread.getThread(),this);

        WiFiManager.getInstance(this, new Litifer.WiFiDeviceListener() {
            @Override
            public void onWiFiDeviceDiscovered(ArrayList wifiDeviceList) {
                // copying it using hashset since shallow copying leads to pass by reference.
                Collection<WifiEntity> exitedWifiList = new HashSet<WifiEntity>(mActiveWifiList.keySet());
                Collection<WifiEntity> enteredWifiList= new HashSet<WifiEntity>(wifiDeviceList);
                Collection<WifiEntity> retainedWifiList = new HashSet<WifiEntity>(mActiveWifiList.keySet());
                exitedWifiList.removeAll(wifiDeviceList);
                enteredWifiList.removeAll(mActiveWifiList.keySet());
                retainedWifiList.retainAll(wifiDeviceList);


                for (WifiEntity wifi:enteredWifiList){
                    mActiveWifiList.put(wifi,new Pair<>(TRIGGER.ENTRY.intValue,0l));
                    wifiServicePresenter.enterEvent(wifi);
                }

                for (WifiEntity wifi:exitedWifiList){
                    int triggerValue;
                    long durationStay = mActiveWifiList.get(wifi).second + stayUnitDuration;
                    triggerValue = mActiveWifiList.get(wifi).first + 1;


                    /**
                     * keep it above the beacon_exit check because it will add beacons to mActiveBeacons if this line is run
                     * after if-else block.
                     */

                    mActiveWifiList.put(wifi, new Pair<>(triggerValue,durationStay));

                    if (triggerValue == TRIGGER.EXIT.intValue) {
                        mActiveWifiList.remove(wifi);
                        wifiServicePresenter.exitEvent(wifi,durationStay);
                    }else if (mActiveWifiList.get(wifi).second/ TRIGGER.TRIGGER_DURATION.intValue != durationStay/ TRIGGER.TRIGGER_DURATION.intValue){
                        wifiServicePresenter.delayEvent(wifi,durationStay);
                    }
                }

                for (WifiEntity wifi:retainedWifiList){
                    long durationStay = mActiveWifiList.get(wifi).second + stayUnitDuration;

                    if (mActiveWifiList.get(wifi).second/ TRIGGER.TRIGGER_DURATION.intValue != durationStay/ TRIGGER.TRIGGER_DURATION.intValue){
                        wifiServicePresenter.delayEvent(wifi,durationStay);
                    }
                    mActiveWifiList.put(wifi,new Pair<>(TRIGGER.ENTRY.intValue,durationStay));

                }

            }

            @Override
            public void didEnterRegion(WifiEntity wifiEntity) {

            }

            @Override
            public void didExitRegion(WifiEntity wifiEntity) {

            }
        }).scanWiFiDevice(DEFAULT_FOREGROUND_SCAN_PERIOD,DEFAULT_FOREGROUND_BETWEEN_SCAN_PERIOD);
    }

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }


    @Override
    public void onDestroy() {
        Log.d("Wifiservice","destroyed");
        super.onDestroy();
         WiFiManager.getInstance(this,null).stopWiFiScan();
    }

    @Override
    public void onTaskRemoved(Intent rootIntent) {
        Intent restartServiceIntent = new Intent(getApplicationContext(), this.getClass());
        restartServiceIntent.setPackage(getPackageName());

        PendingIntent restartServicePendingIntent = PendingIntent.getService(getApplicationContext(), 1, restartServiceIntent, PendingIntent.FLAG_ONE_SHOT);

        AlarmManager alarmService = (AlarmManager) getApplicationContext().getSystemService(Context.ALARM_SERVICE);
        alarmService.set(
                AlarmManager.ELAPSED_REALTIME,
                SystemClock.elapsedRealtime() + 1000,
                restartServicePendingIntent);
        Log.d("WifiService","ontask wifi");
        super.onTaskRemoved(rootIntent);
    }


}
