package litifer.com.sdk.presentation;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.support.v4.content.ContextCompat;
import android.util.Log;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import litifer.com.sdk.data.net.InternetUtility;
import litifer.com.sdk.presentation.Litifer.WiFiDeviceListener;

import litifer.com.sdk.data.model.WifiEntity;

/**
 * Created by kishlaykishore on 06/06/17.
 */

public class WiFiManager {
    Context context;
    //
    private Handler mHandler;
    WifiManager wifiManager;
    private Timer WIFIscanTimer;
    private TimerTask WIFIscanTimerTask;
    WiFiManager.WiFiReceiver wiFiReceiver;
    WiFiDeviceListener wiFiDeviceListener;


    private static WiFiManager mWifiManager;

    private WiFiManager(Context context, WiFiDeviceListener listener) {
        this.context = context;
        this.mHandler = new Handler();
        this.wifiManager = (WifiManager)context.getSystemService(context.WIFI_SERVICE);
        this.wiFiReceiver = new WiFiManager.WiFiReceiver();
        this.wiFiDeviceListener = listener;
    }

    public static WiFiManager getInstance(Context context,WiFiDeviceListener listener){
        if (mWifiManager==null){
            mWifiManager=new WiFiManager(context,listener);
        }
        return mWifiManager;
    }

    public void scanWiFiDevice(int SCAN_PERIOD, int WAIT_PERIOD) {
        if(InternetUtility.getInstance(context).isWifiEnabled()) {
            this.WIFIscanTimer = new Timer();
            this.intitializeWIFIscanTimerTask(WAIT_PERIOD);
            this.WIFIscanTimer.schedule(this.WIFIscanTimerTask, SCAN_PERIOD, WAIT_PERIOD);
        }else {
            System.out.println("Wifi is disabled.");
        }

    }

    public void stopWiFiScan() {
        if(this.WIFIscanTimer != null) {
            try {
                this.WIFIscanTimer.cancel();
                this.WIFIscanTimer = null;
                this.context.unregisterReceiver(this.wiFiReceiver);
            } catch (Exception var2) {
                ;
            }
        }
    }

    private void intitializeWIFIscanTimerTask(final long WAIT_PERIOD) {
        this.WIFIscanTimerTask = new TimerTask() {
            public void run() {
                try {
                    if(ContextCompat.checkSelfPermission(WiFiManager.this.context, "android.permission.ACCESS_COARSE_LOCATION") == 0 && ContextCompat.checkSelfPermission(WiFiManager.this.context, "android.permission.ACCESS_FINE_LOCATION") == 0) {
                        WiFiManager.this.mHandler.postDelayed(new Runnable() {
                            public void run() {
                            }
                        }, WAIT_PERIOD - 10L);
                        WiFiManager.this.context.registerReceiver(WiFiManager.this.wiFiReceiver, new IntentFilter("android.net.wifi.SCAN_RESULTS"));
                        WiFiManager.this.wifiManager.startScan();
                    }
                } catch (Exception var2) {
                    var2.printStackTrace();
                }

            }
        };
    }

    private double calculateDistance(double levelInDb, double freqInMHz) {
        double exp = (27.55D - 20.0D * Math.log10(freqInMHz) + Math.abs(levelInDb)) / 20.0D;
        return Math.pow(10.0D, exp);
    }

    class WiFiReceiver extends BroadcastReceiver {
        WiFiReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            List wifiScanResults = WiFiManager.this.wifiManager.getScanResults();
            new ArrayList();
            List results = null;
            ArrayList wifiDevices = new ArrayList();

            try {
                results = WiFiManager.this.wifiManager.getScanResults();
                if(results != null) {
                    for(int i = 0; i < results.size(); ++i) {
                        DecimalFormat df = new DecimalFormat("#.##");
                        String distanceInMeter = df.format(WiFiManager.this.calculateDistance((double)((ScanResult)results.get(i)).level, (double)((ScanResult)results.get(i)).frequency));
                        String BSSID = ((ScanResult)results.get(i)).BSSID;
                        String wifiId = BSSID.replace(":", "");
                        float distance = Float.parseFloat(distanceInMeter);
                        int Level = Integer.parseInt(String.valueOf(((ScanResult)results.get(i)).level));
                        float frequency = (float)((ScanResult)results.get(i)).frequency;
                        String venueName = null;
                        String operatorFriendlyName = null;
                        if(Build.VERSION.SDK_INT >= 23) {
                            venueName = String.valueOf(((ScanResult)results.get(i)).venueName);
                            operatorFriendlyName = (String)((ScanResult)results.get(i)).operatorFriendlyName;

                        }
                        WifiEntity wifiDevice = new WifiEntity();
                        wifiDevice.setBSSID(wifiId);
                        wifiDevice.setDistance(distance);
                        wifiDevice.setLevel(Level);
                        wifiDevice.setFrequency(frequency);
                        wifiDevice.setVenueName(venueName);
                        wifiDevice.setOperatorFriendlyName(operatorFriendlyName);


                        for(int j = 0; j < wifiDevices.size(); ++j) {
                            if(wifiDevice.getBSSID().equalsIgnoreCase(((WifiEntity)wifiDevices.get(j)).getBSSID())) {
                                wifiDevices.remove(j);
                                break;
                            }

//                            else {
//                                WiFiManager.this.wiFiDeviceListener.didEnterRegion(wifiDevice);
//                            }
                        }

                        wifiDevices.add(wifiDevice);
                        Collections.sort(wifiDevices);
//                        WiFiManager.this.wiFiDeviceListener.onWiFiDeviceDiscovered(wifiDevices);
                    }
                    WiFiManager.this.wiFiDeviceListener.onWiFiDeviceDiscovered(wifiDevices);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    }
}
