package litifer.com.sdk.presentation;

import android.app.IntentService;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.pm.PackageManager;

/**
 * Created by kishlaykishore on 14/06/17.
 */

public class MessageInteractionService extends IntentService {

    public enum Type {
        OPEN, DELETE
    }

    public enum Source {
        INBOX, NOTIFICATION
    }
    /**
     * Creates an IntentService.  Invoked by your subclass's constructor.
     */
    public MessageInteractionService() {
        super("MessageInteractionService");
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        Type type = (Type) intent.getSerializableExtra("type");
        Source source = (Source) intent.getSerializableExtra("source");
        String message = intent.getParcelableExtra("message");
//        PendingIntent launchIntent = intent.getParcelableExtra("launch-intent");


        PackageManager packageManager = this.getPackageManager();
        Intent launchIntent = packageManager.getLaunchIntentForPackage(this.getPackageName());
        intent.addFlags(intent.FLAG_ACTIVITY_CLEAR_TOP);
        PendingIntent pendingIntent = PendingIntent.getActivity(this,0,launchIntent, PendingIntent.FLAG_ONE_SHOT);

        if (source == Source.NOTIFICATION) {
            if (type == Type.OPEN) {
                //to-do
                try {
                    pendingIntent.send();
                } catch (PendingIntent.CanceledException e) {
                    e.printStackTrace();
                }
            } else {
                //to-do
            }
        }

    }
}
