//package litifer.com.sdk.presentation;
//
//import android.app.Application;
//import android.content.Context;
//import android.content.Intent;
//import android.os.IBinder;
//import android.os.RemoteException;
//import android.util.Log;
//import android.util.Pair;
//
//import org.altbeacon.beacon.Beacon;
//import org.altbeacon.beacon.BeaconConsumer;
//import org.altbeacon.beacon.BeaconManager;
//import org.altbeacon.beacon.BeaconParser;
//import org.altbeacon.beacon.Identifier;
//import org.altbeacon.beacon.RangeNotifier;
//import org.altbeacon.beacon.Region;
//import org.altbeacon.beacon.startup.BootstrapNotifier;
//import org.altbeacon.beacon.startup.RegionBootstrap;
//
//import java.util.ArrayList;
//import java.util.Collection;
//import java.util.HashMap;
//import java.util.HashSet;
//
//import litifer.com.sdk.data.net.InternetUtility;
//import litifer.com.sdk.domain.executor.impl.JobExecutor;
//import litifer.com.sdk.presentation.presenters.BeaconServicePresenter;
//import litifer.com.sdk.presentation.presenters.ExitRegionPresenter;
//import litifer.com.sdk.presentation.presenters.TimedEventsPresenter;
//import litifer.com.sdk.presentation.subscriber.thread.UIThread;
//import litifer.com.sdk.presentation.ui.activities.MainActivity;
//
///**
// * Created by kishlaykishore on 05/04/17.
// */
//
//public class LitiferApplication extends Application  implements BootstrapNotifier, BeaconConsumer, RangeNotifier {
//
//    HashMap<Beacon,Pair<Integer,Long>> mActiveBeacons=new HashMap<Beacon, Pair<Integer,Long>>();
//
//    public enum TRIGGER{
//        ENTRY(0),
//        EXIT(5),
//        TRIGGER_DURATION(60000);
//
//        public int intValue;
//        private TRIGGER(int intValue){
//            this.intValue=intValue;
//        }
//
//    }
//    private BeaconManager beaconManager;
//    private String TAG = ".BootStrapNotifier";
//    private RegionBootstrap regionBootstrap;
//    private BeaconServicePresenter enterRegionPresenter;
//    private ExitRegionPresenter exitRegionPresenter;
//    private TimedEventsPresenter timedEventsPresenter;
//    private boolean isAppForeground;
//    private long stayUnitDuration;
//    private Region regionToMonitor=new Region("myMonitoringUniqueId", null,null,null);
//
//    @Override
//    public void onCreate() {
//        super.onCreate();
//        Log.d(TAG, "App started up");
//
//        beaconManager=BeaconManager.getInstanceForApplication(this);
//        beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(BeaconParser.ALTBEACON_LAYOUT));
//        beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout("m:2-3=0215,i:4-19,i:20-21,i:22-23,p:24-24"));
//        beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(BeaconParser.URI_BEACON_LAYOUT));
//        beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(BeaconParser.EDDYSTONE_UID_LAYOUT));
//        beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(BeaconParser.EDDYSTONE_TLM_LAYOUT));
//
//        isAppForeground = InternetUtility.init(getApplicationContext()).isAppForground();
//        if (isAppForeground){
//            stayUnitDuration = BeaconManager.DEFAULT_FOREGROUND_BETWEEN_SCAN_PERIOD+BeaconManager.DEFAULT_FOREGROUND_SCAN_PERIOD;
//        }else {
//            stayUnitDuration = BeaconManager.DEFAULT_BACKGROUND_BETWEEN_SCAN_PERIOD+BeaconManager.DEFAULT_BACKGROUND_SCAN_PERIOD;
//        }
//
//        enterRegionPresenter=new BeaconServicePresenter(new JobExecutor(),UIThread.getThread(),this);
//        exitRegionPresenter=new ExitRegionPresenter(new JobExecutor(),UIThread.getThread(),this);
//        timedEventsPresenter=new TimedEventsPresenter(new JobExecutor(),UIThread.getThread(),this);
//
//        Region region = new Region("startMonitoring", null, null, null);
//
//        regionBootstrap = new RegionBootstrap(this, region);
//        beaconManager.bind(this);
//    }
//
//
//    @Override
//    public void didEnterRegion(Region region) {
//        Log.d(TAG, "didEnterRegion");
//        try {
//            beaconManager.startRangingBeaconsInRegion(region);
//        } catch (RemoteException e) {
//            e.printStackTrace();
//        }
//
//    }
//
//
//    @Override
//    public void didExitRegion(Region region) {
//        Log.d(TAG,"didExitRegion");
//        try {
//            beaconManager.stopRangingBeaconsInRegion(region);
//
//        } catch (RemoteException e) {
//            e.printStackTrace();
//        }
//    }
//
//    @Override
//    public void didDetermineStateForRegion(int i, Region region) {
//        System.out.println("state is :"+ i);
//    }
//
//    @Override
//    public void didRangeBeaconsInRegion(Collection<Beacon> beacons, Region region) {
//        Log.d(TAG,"didRangeBeaconsInRegion beacon count : "+ beacons.size());
//
//        // copying it using hashset since shallow copying leads to pass by reference.
//        Collection<Beacon> exitedBeacons = new HashSet<Beacon>(mActiveBeacons.keySet());
//        Collection<Beacon> enteredBeacons= new HashSet<Beacon>(beacons);
//        Collection<Beacon> retainedbeacons = new HashSet<Beacon>(mActiveBeacons.keySet());
//        exitedBeacons.removeAll(beacons);
//        enteredBeacons.removeAll(mActiveBeacons.keySet());
//        retainedbeacons.retainAll(beacons);
//
//        for (Beacon beacon:enteredBeacons){
//            mActiveBeacons.put(beacon,new Pair<>(TRIGGER.ENTRY.intValue,0l));
//            enterRegionPresenter.sendEvent(beacon);
//        }
//
//        for (Beacon beacon:exitedBeacons){
//            int triggerValue;
//            long durationStay = mActiveBeacons.get(beacon).second + stayUnitDuration;
//            triggerValue = mActiveBeacons.get(beacon).first + 1;
//
//
//            if (triggerValue == TRIGGER.EXIT.intValue) {
//                mActiveBeacons.remove(beacon);
//                exitRegionPresenter.sendEvent(beacon,durationStay);
//            }else if (mActiveBeacons.get(beacon).second/ TRIGGER.TRIGGER_DURATION.intValue != durationStay/ TRIGGER.TRIGGER_DURATION.intValue){
//                timedEventsPresenter.sendEvent(beacon,durationStay);
//            }
//
//            mActiveBeacons.put(beacon, new Pair<>(triggerValue,durationStay));
//
//        }
//
//        for (Beacon beacon:retainedbeacons){
//            long durationStay = mActiveBeacons.get(beacon).second + stayUnitDuration;
//
//            if (mActiveBeacons.get(beacon).second/ TRIGGER.TRIGGER_DURATION.intValue != durationStay/ TRIGGER.TRIGGER_DURATION.intValue){
//                timedEventsPresenter.sendEvent(beacon,durationStay);
//            }
//            mActiveBeacons.put(beacon,new Pair<>(TRIGGER.ENTRY.intValue,durationStay));
//
//        }
//
//
//    }
//
////                bluetoothCrashResolver.notifyScannedDevice(device, myLeScanCallback)
//
//    @Override
//    public void onBeaconServiceConnect() {
//        beaconManager.addRangeNotifier(this);
//    }
//}
