package litifer.com.sdk.presentation;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.sip.SipAudioCall;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.util.Log;
import android.util.Pair;
import android.widget.Toast;


import java.util.ArrayList;
import java.util.List;
import java.util.Map;


import litifer.com.sdk.data.exeption.ApplicationNotSetException;
import litifer.com.sdk.data.exeption.ErrorMessageFactory;
import litifer.com.sdk.data.local.LitiferSharedPreferences;

import litifer.com.sdk.data.model.ApiCallsConfig;
import litifer.com.sdk.data.model.ConfigEntity;
import litifer.com.sdk.data.model.CustomerEntity;
import litifer.com.sdk.data.model.DeviceEntity;
import litifer.com.sdk.data.model.GeofenceEntity;
import litifer.com.sdk.data.model.MessageEntity;

import litifer.com.sdk.data.model.NotificationTemplateEntity;
import litifer.com.sdk.data.model.WifiEntity;
import litifer.com.sdk.domain.executor.impl.JobExecutor;
import litifer.com.sdk.presentation.presenters.ReceiveNotificationPresenter;
import litifer.com.sdk.presentation.presenters.LitiferManagerPresenter;
import litifer.com.sdk.presentation.presenters.WifiServicePresenter;
import litifer.com.sdk.presentation.presenters.base.Delegates;
import litifer.com.sdk.presentation.subscriber.thread.UIThread;

/**
 * Created by kishlaykishore on 08/03/17.
 */

public class Litifer {

    private String TAG = "Litifer";

    //instantiating Litifer Manager

    private static Litifer litifer;
    private Context mContext;
    private Litifer(Context context) {
        mContext=context;
    }

    //intents to start corresponding services.
    private Intent beaconServiceIntent;
    private Intent geofireServiceIntent;
    private Intent geofenceServiceIntent;

    //to save device only once and hence generate tokens only once.
    private boolean mSaveDevice = true;




    //listeners . Observers
    public interface SaveConfigListener{
        void onSuccess(String message);
        void onFailure(String errorMessage);
    }

    public interface MonitoringListener{
        void onSuccess(String message);
        void onFailure();
    }

    public interface WiFiDeviceListener{
        void onWiFiDeviceDiscovered(ArrayList wifiDeviceList);
        void didEnterRegion(WifiEntity wifiEntity);
        void didExitRegion(WifiEntity wifiEntity);
    }

    public interface InboxListener{
        void onSuccess(ArrayList<NotificationTemplateEntity> notifications);
        void onFailure(String error);
    }


    public interface GeofenceListener{
        void onSuccess(List<GeofenceEntity> geofenceEntities);
        void onFailure(String error);
    }
    /**
     * @param context This is the activity context from where this is called.
     * @return {@link Litifer This doc }
     */
    public static Litifer init(Context context){
        if (litifer == null){
            litifer = new Litifer(context);
        }
        return litifer;
    }

    public DeviceEntity addDevice(){
        return DeviceEntity.getInstance();
    }


    public CustomerEntity addCustomer() {
        /**
         * Setting device entitiy for customer before setting up device itself would work, since it's a singleton and
         * on setting up device data will be sent to server.
         *
         */
        return CustomerEntity.getInstance()
                .setDeviceEntity(DeviceEntity.getInstance());
    }

    public ConfigEntity config(){
        return ConfigEntity.getInstance(mContext)
                .setToken(LitiferSharedPreferences.getInstance(mContext).retrieveKey(ApiCallsConfig.getInstance().getDEVICE_TOKEN()));
    }

    public void saveConfig(SaveConfigListener saveConfigListener){
        if (ConfigEntity.getInstance(mContext).getToken() == ConfigEntity.EMPTY_TOKEN && mSaveDevice==true) {
            configureDevice();
            new LitiferManagerPresenter(new JobExecutor(), UIThread.getThread(),mContext).register(saveConfigListener);
            mSaveDevice=false;
        }else {
            if (ConfigEntity.getInstance(mContext).getToken()==ConfigEntity.EMPTY_TOKEN){
                Log.i(TAG+"/saveConfig","Token already set. To reset reinstall the app.");
            }
        }
    }

    public void startMonitoring(MonitoringListener monitoringListener){
        new WifiServicePresenter(new JobExecutor(), UIThread.getThread(), mContext).setListener(monitoringListener);
        startMonitoringBeacon();
        WifiManager wifi = (WifiManager) mContext.getSystemService(Context.WIFI_SERVICE);
        if (wifi.isWifiEnabled()){
            Log.d(TAG,"wifi service started");
            startMonitoringWifi();
        }


        setBackgroundMonitoring(ConfigEntity.getInstance(mContext).isBackgroundMonitoringEnabled());
    }

    public void close(){

    }

    //enabling background monitoring
    public boolean setBackgroundMonitoring(boolean doMonitor) {
        if (doMonitor){
            mContext.getPackageManager().setComponentEnabledSetting(new ComponentName(mContext.getApplicationContext(),BeaconReceiver.class),PackageManager.COMPONENT_ENABLED_STATE_ENABLED,PackageManager.DONT_KILL_APP);
            mContext.getPackageManager().setComponentEnabledSetting(new ComponentName(mContext.getApplicationContext(),WifiStartReceiver.class),PackageManager.COMPONENT_ENABLED_STATE_ENABLED,PackageManager.DONT_KILL_APP);
            Log.i(TAG,"enabled background");
            return true;

        }else {
            mContext.getPackageManager().setComponentEnabledSetting(new ComponentName(mContext.getApplicationContext(),BeaconReceiver.class),PackageManager.COMPONENT_ENABLED_STATE_DISABLED,PackageManager.DONT_KILL_APP);
            mContext.getPackageManager().setComponentEnabledSetting(new ComponentName(mContext.getApplicationContext(),WifiStartReceiver.class),PackageManager.COMPONENT_ENABLED_STATE_ENABLED,PackageManager.DONT_KILL_APP);
            Log.i(TAG,"Background Monitoring not enabled.");
            return false;
        }
    }


//    private void setupGeofire(){
//        GeofenceRepositoryImpl.init(mContext,new GeofenceJsonMapper()).setupGeofire();
//    }


//    }



    //utility methods in the manager.
    public void configureDevice(){
        DeviceEntity.getInstance()
                .setDeviceID(Settings.Secure.getString(mContext.getContentResolver(),
                        Settings.Secure.ANDROID_ID))
                .setPackageName(mContext.getApplicationContext().getPackageName());
    }



    public void startMonitoringBeacon(){
        setBeaconIntent();
        mContext.startService(beaconServiceIntent);
//        mContext.bindService(beaconServiceIntent, mServiceConnection, Context.BIND_AUTO_CREATE);
    }

    public void startMonitoringWifi(){
        mContext.startService(new Intent(mContext,WifiService.class));
    }

    public void scanWiFiDevice(int SCAN_PERIOD, int WAIT_PERIOD) {

        WiFiManager.getInstance(mContext, new WiFiDeviceListener() {
                    @Override
                    public void onWiFiDeviceDiscovered(ArrayList wifiDeviceList) {
                        System.out.println("WifiDeviceList is : "+ wifiDeviceList);
                    }

                    @Override
                    public void didEnterRegion(WifiEntity wifiEntity) {
                        System.out.println("Wifi Entered Region : " + wifiEntity);
                    }

                    @Override
                    public void didExitRegion(WifiEntity wifiEntity) {

                    }
                }
        ).scanWiFiDevice(SCAN_PERIOD,WAIT_PERIOD);
    }

    public void stopWiFiScan() {
        WiFiManager.getInstance(mContext,null).stopWiFiScan();
    }


    private void setBeaconIntent(){
        beaconServiceIntent=new Intent(mContext,BeaconService.class);
//        beaconServiceIntent.putExtra("DelegateClass",(Serializable)mContext);
    }


    //fcm receive message

    public void receiveFcmMessage(Map<String,String> remoteMessage){
        new ReceiveNotificationPresenter(new JobExecutor(), UIThread.getThread(), new Delegates.NotificationDeliveryObserver() {
            @Override
            public void onMessageReceived(MessageEntity message) {

            }
        }, mContext).receiveFcmMessage(remoteMessage);
    }


    public void getGeofenceList(double latitude, double longitude, GeofenceListener geofenceListener){
        new LitiferManagerPresenter(new JobExecutor(),UIThread.getThread(),mContext).fetchGeofences(geofenceListener,latitude,longitude);
    }

    public static boolean isLitiferMessage(Map<String,String> data ) {
        return (data != null && data.containsKey("_litifer"));
    }



    //VIEWS
    public void addInbox(InboxListener listener) {
        new LitiferManagerPresenter(new JobExecutor(),UIThread.getThread(),mContext).fetchInboxContent(listener);

    }

//    public void RatingBarReview(String rateBar,String cleanBar, String comment)
//    {
//        new AddcustomerReviewPresenter(new JobExecutor(),UIThread.getThread(), (Delegates.ApiResponse)mContext, mContext,rateBar,cleanBar,comment).RatingPostServer();
//    }


    public static class ListItem {
        private String head;
        private String desc;

        public ListItem(String head, String desc) {
            this.head = head;
            this.desc = desc;
        }

        public String getHead() {
            return head;
        }

        public String getDesc() {
            return desc;
        }
    }
//unused
//
//    public void addBeaconsToRegion() {
//        System.out.println("saved to all beacons");
//        new AddBeaconsToRegionPresenter(new JobExecutor(), UIThread.getThread(), new Delegates.BeaconRegistrationObserver() {
//            @Override
//            public void beaconRegionsListener(ArrayList<Region> regions) {
//                mBeaconService.beaconRegionsListener(regions);
//            }
//
//            @Override
//            public void addBootstrapNotifierRegions(ArrayList<Region> regions) {
//
//            }
//        }, mContext).addBeaconsToRegion();
//    }
//
//
//    public void stopMonitoringBeacon(){
//        mContext.stopService(beaconServiceIntent);
//    }
//
//    public void startGeofireService(){
//        setGeofireIntent();
//        mContext.startService(geofireServiceIntent);
//    }
//
//    public void stopGeofireService() {
//        mContext.stopService(geofireServiceIntent);
//    }
//
//    public void startMonitoringGeofence(){
//        setGeofenceIntent();
//        mContext.startService(geofenceServiceIntent);
//    }
//
//    public void stopMonitoringGeofence(){
//        mContext.stopService(geofenceServiceIntent);
//    }
//
//    public void fetchGeofencefromServer(Delegates.GeofenceObserver geofenceObserver) {
//        new FetchGeofencePresenter(new JobExecutor(),UIThread.getThread(), geofenceObserver,mContext).fetchGeofencefromServer();
//    }
//
//
//
//
//    public void fetchNotificationsfromServer(Delegates.NotificationsObserver notificationsObserver) {
//        new AddNotificationsPresenter(new JobExecutor(),UIThread.getThread(), notificationsObserver,mContext).fetchNotificationsfromServer();
//    }
//

//    /*
//
//    private void setGeofenceIntent() {
//        geofenceServiceIntent = new Intent(mContext,GeofenceService.class);
//        geofenceServiceIntent.putExtra("DelegateClass",(Serializable) mContext);
//    } */
//
//    public void deleteAllBeaconsfromRealm(Delegates.BeaconsObserver beaconsObserver){
//        new FetchBeaconsPresenter(new JobExecutor(), UIThread.getThread(), beaconsObserver, mContext).deleteAllBeaconsfromRealm();
//    }
//
//    private void setGeofireIntent(){
//        geofireServiceIntent= new Intent(mContext,GeofireService.class);
//    }
//
//    private void setGeofenceIntent(){
//        geofenceServiceIntent= new Intent(mContext,LocationService.class);
//    }

//    //binding Binding beacon service to litifer manager.
//    private boolean mServiceBound = false;
//    private BeaconService mBeaconService;
//
//    private ServiceConnection mServiceConnection = new ServiceConnection() {
//
//        @Override
//        public void onServiceDisconnected(ComponentName name) {
//            mServiceBound = false;
//        }
//
//        @Override
//        public void onServiceConnected(ComponentName name, IBinder service) {
//            BeaconService.MyBinder myBinder = (BeaconService.MyBinder) service;
//            mBeaconService = myBinder.getService();
//            mServiceBound = true;
//        }
//    };


}

