package litifer.com.sdk.presentation;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

public class BeaconReceiver extends BroadcastReceiver {

    private String TAG = "BeaconsReceiver";
    public BeaconReceiver() {
    }

    @Override
    public void onReceive(Context context, Intent intent) {

        // TODO: This method is called when the BroadcastReceiver is receiving
        // an Intent broadcast.
        //********** Basic validation **********
        if (intent == null) {
            Log.d(TAG,"Received null intent");
            return;
        }

        Log.d(TAG,"Intent Received."+intent.getAction());

        String intentAction = intent.getAction();
        if (intentAction == null) {
            Log.d(TAG, "Received intent without intent action string");
            return;
        }
        BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if(!mBluetoothAdapter.isEnabled()){
            Log.d(TAG,"bluetooth not enabled");
            return;
        }

        context.startService(new Intent(context,BeaconService.class));
    }
}
