package litifer.com.sdk.domain.interactors;

import android.content.Context;
import android.util.Log;


import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;

import litifer.com.sdk.data.local.LitiferSharedPreferences;
import litifer.com.sdk.data.mapper.CustomerJsonMapper;
import litifer.com.sdk.data.model.ConfigEntity;
import litifer.com.sdk.data.model.CustomerEntity;
import litifer.com.sdk.data.model.URLEntity;
import litifer.com.sdk.data.net.InternetUtility;
import litifer.com.sdk.domain.executor.ThreadExecutor;
import litifer.com.sdk.domain.interactors.base.AbstractInteractor;
import litifer.com.sdk.presentation.subscriber.thread.PostExecutionThread;
import rx.Observable;
import rx.Subscriber;

/**
 * Created by kishlaykishore on 11/04/17.
 */

public class RegisterOnServerInteractor extends AbstractInteractor {

    private String TAG="RGS";


    public RegisterOnServerInteractor(ThreadExecutor threadExecutor, PostExecutionThread postExecutionThread, Context context) {
        super(threadExecutor,postExecutionThread,context);
    }

    @Override
    protected Observable buildUseCaseObservable() throws IOException{

        try {
            final JSONObject body = new JSONObject(new CustomerJsonMapper().transformCustomerEntityToJson(CustomerEntity.getInstance()));
            Log.d(TAG,body.toString());

        return Observable.create(new Observable.OnSubscribe<String>() {
            @Override
            public void call(Subscriber<? super String> subscriber) {
                try {
                    String response = InternetUtility.getInstance(context).postCall(URLEntity.getInstance().getRegisterApi(),body,subscriber);
                    ConfigEntity.getInstance(context).setToken(new JSONObject(response).get("token").toString());
                    subscriber.onNext("Registered on Server"); // Emit the contents of the URL
                    subscriber.onCompleted(); // Nothing more to emit
                }catch(Exception e){
                    subscriber.onError(e); // In case there are network errors
                }
            }
        });

        } catch (JSONException e) {
            e.printStackTrace();
        }

        return null;

    }
}
