package litifer.com.sdk.domain.interactors;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;

import litifer.com.sdk.domain.executor.ThreadExecutor;
import litifer.com.sdk.presentation.MessageInteractionService;
import litifer.com.sdk.presentation.presenters.base.AbstractPresenter;
import litifer.com.sdk.presentation.subscriber.thread.PostExecutionThread;

/**
 * Created by kishlaykishore on 12/04/17.
 */

public class ReceiveNotificationInteractor extends AbstractPresenter{

    private String TAG="NotificationInteractor";
    public ReceiveNotificationInteractor(ThreadExecutor executor, PostExecutionThread postExecutionThread, Context context){
        super(executor,postExecutionThread,context);
    }

    public void deliverNotification(String notificationTitle, String messageBody, String link, Bitmap largeIcon, NotificationCompat.Style abstractStyle, Uri audioTrack,String notification_id){

        int ic_launcher = getLogofromApp();

        PackageManager packageManager = mContext.getPackageManager();


//        Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(link));
//        intent.setData(Uri.parse(link));
//        Intent intent = packageManager.getLaunchIntentForPackage(mContext.getPackageName());
//        intent.addFlags(intent.FLAG_ACTIVITY_CLEAR_TOP);
//        PendingIntent pendingIntent = PendingIntent.getActivity(mContext,0,intent, PendingIntent.FLAG_ONE_SHOT);


        Intent messageInteractionServiceOpenIntent = new Intent(mContext,MessageInteractionService.class);
        messageInteractionServiceOpenIntent.putExtra("source", MessageInteractionService.Source.NOTIFICATION);
        messageInteractionServiceOpenIntent.putExtra("type", MessageInteractionService.Type.OPEN);
        messageInteractionServiceOpenIntent.putExtra("message_id", notification_id);
        PendingIntent contentintent = PendingIntent.getService(mContext, 0, messageInteractionServiceOpenIntent, PendingIntent.FLAG_ONE_SHOT);


        Intent deleteInteractionServiceOpenIntent = new Intent(mContext,MessageInteractionService.class);
        deleteInteractionServiceOpenIntent.putExtra("source", MessageInteractionService.Source.NOTIFICATION);
        deleteInteractionServiceOpenIntent.putExtra("type", MessageInteractionService.Type.DELETE);
        deleteInteractionServiceOpenIntent.putExtra("message_id", notification_id);
        PendingIntent deleteintent = PendingIntent.getService(mContext, 0, deleteInteractionServiceOpenIntent, PendingIntent.FLAG_CANCEL_CURRENT);

        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(mContext)
            .setSmallIcon(ic_launcher)
            .setLargeIcon(largeIcon)
            .setContentTitle(notificationTitle)
            .setContentText(messageBody)
            .setStyle(abstractStyle)
//                .addAction(android.R.drawable.ic_dialog_map,"DIRECTION",pendingIntent)
            .setContentIntent(contentintent)
            .setDeleteIntent(deleteintent)
            .setPriority(2) //Notification.PRIORITY_MAX
            .setSound(audioTrack)
            .setAutoCancel(false);


//        .setStyle(new NotificationCompat.BigPictureStyle().bigPicture(image))
        NotificationManager notificationManager = (NotificationManager) mContext.getSystemService(Context.NOTIFICATION_SERVICE);
        notificationManager.notify(0,notificationBuilder.build());

    }

    private int getLogofromApp(){
        int ic_launcher = 0;

        if (mContext.getApplicationContext().getResources().getIdentifier("ic_launcher", "drawable", mContext.getApplicationContext().getPackageName()) != 0){
            ic_launcher = mContext.getApplicationContext().getResources().getIdentifier("ic_launcher", "drawable", mContext.getApplicationContext().getPackageName());
        }else if (mContext.getApplicationContext().getResources().getIdentifier("ic_launcher", "mipmap", mContext.getApplicationContext().getPackageName()) != 0){
            ic_launcher = mContext.getApplicationContext().getResources().getIdentifier("ic_launcher", "mipmap", mContext.getApplicationContext().getPackageName());
        }else {
            System.out.println("ic_lancher logo not found.");
        }
        return ic_launcher;
    }
}
