package litifer.com.sdk.domain.interactors;

import android.content.Context;

import org.altbeacon.beacon.Beacon;

import java.io.IOException;

import litifer.com.sdk.data.mapper.EventJsonMapper;
import litifer.com.sdk.data.model.EventTypeEntity;
import litifer.com.sdk.data.repository.impl.EventsRepository;
import litifer.com.sdk.domain.executor.ThreadExecutor;
import litifer.com.sdk.domain.interactors.base.AbstractInteractor;
import litifer.com.sdk.presentation.subscriber.thread.PostExecutionThread;
import rx.Observable;

/**
 * Created by Mehsaan on 21-07-2017.
 */

public class GeofenceRegionInteractor extends AbstractInteractor {
    private String geofenceid;
    private String geofencetype;
    public GeofenceRegionInteractor(ThreadExecutor threadExecutor, PostExecutionThread postExecutionThread, Context context, String id,String Type) {
        super(threadExecutor,postExecutionThread,context);
         geofenceid = id;
        geofencetype=Type;
    }

    @Override
    protected Observable buildUseCaseObservable() throws IOException {
        return EventsRepository.getInstance(context,new EventJsonMapper()).sendGeofenceTriggerToServer(geofenceid,geofencetype);
    }
}
