package litifer.com.sdk.domain.interactors;

import android.content.Context;

import java.io.IOException;

import litifer.com.sdk.data.mapper.BeaconJsonMapper;
import litifer.com.sdk.data.repository.impl.InboxRepository;
import litifer.com.sdk.domain.executor.ThreadExecutor;
import litifer.com.sdk.domain.interactors.base.AbstractInteractor;
import litifer.com.sdk.presentation.subscriber.thread.PostExecutionThread;
import rx.Observable;

/**
 * Created by kishlaykishore on 16/06/17.
 */

public class FetchInboxInteractor extends AbstractInteractor {
    public FetchInboxInteractor(ThreadExecutor threadExecutor, PostExecutionThread postExecutionThread, Context context) {
        super(threadExecutor,postExecutionThread,context);
    }

    @Override
    protected Observable buildUseCaseObservable() throws IOException {
        return InboxRepository.getInstance(context,new BeaconJsonMapper()).getAll();
    }
}
