package litifer.com.sdk.domain.interactors;

import android.content.Context;

import java.io.IOException;

import litifer.com.sdk.data.mapper.EventJsonMapper;
import litifer.com.sdk.data.mapper.GeofenceJsonMapper;
import litifer.com.sdk.data.repository.impl.GeofenceRepository;
import litifer.com.sdk.domain.executor.ThreadExecutor;
import litifer.com.sdk.domain.interactors.base.AbstractInteractor;
import litifer.com.sdk.presentation.subscriber.thread.PostExecutionThread;
import rx.Observable;

/**
 * Created by kishlaykishore on 22/08/17.
 */

public class FetchGeofenceInterator extends AbstractInteractor{
    private double lat;
    private double lon;

    public FetchGeofenceInterator(ThreadExecutor threadExecutor, PostExecutionThread postExecutionThread, Context context, double lat, double lon) {
        super(threadExecutor, postExecutionThread, context);
        this.lat=lat;
        this.lon=lon;
    }

    @Override
    protected Observable buildUseCaseObservable() throws IOException {
        return GeofenceRepository.getInstance(context,new GeofenceJsonMapper()).getGeofencesFromServer(lat,lon);
    }
}
