package litifer.com.sdk.domain.interactors;

import android.content.Context;

import java.io.IOException;

import litifer.com.sdk.data.mapper.EventJsonMapper;
import litifer.com.sdk.data.model.EventTypeEntity;
import litifer.com.sdk.data.model.WifiEntity;
import litifer.com.sdk.data.repository.impl.EventsRepository;
import litifer.com.sdk.domain.executor.ThreadExecutor;
import litifer.com.sdk.domain.interactors.base.AbstractInteractor;
import litifer.com.sdk.presentation.subscriber.thread.PostExecutionThread;
import rx.Observable;

/**
 * Created by kishlaykishore on 07/06/17.
 */

public class ExitWifiRegionInteractor extends AbstractInteractor{
    private String TAG="ExitWifiRegionIntr";
    private WifiEntity mWifi;
    private long mTime;

    public ExitWifiRegionInteractor(ThreadExecutor threadExecutor, PostExecutionThread postExecutionThread, Context context, WifiEntity wifiEntity, long time) {
        super(threadExecutor,postExecutionThread,context);
        mWifi=wifiEntity;
        mTime=time;
    }

    @Override
    protected Observable buildUseCaseObservable(){
        return EventsRepository.getInstance(context,new EventJsonMapper()).sendWifiTriggerToServer(mWifi, EventTypeEntity.WIFI_EXIT.toString());
    }


}
