package litifer.com.sdk.domain.interactors;

import android.content.Context;

import org.altbeacon.beacon.Beacon;

import java.io.IOException;

import litifer.com.sdk.data.mapper.EventJsonMapper;
import litifer.com.sdk.data.model.EventTypeEntity;
import litifer.com.sdk.data.repository.impl.EventsRepository;
import litifer.com.sdk.domain.executor.ThreadExecutor;
import litifer.com.sdk.domain.interactors.base.AbstractInteractor;
import litifer.com.sdk.presentation.subscriber.thread.PostExecutionThread;
import rx.Observable;

/**
 * Created by kishlaykishore on 08/04/17.
 */

public class ExitBeaconRegionInteractor extends AbstractInteractor {
    private String TAG="ExitRegionIntr";
    private Beacon mBeacon;
    private long mTime;
    public ExitBeaconRegionInteractor(ThreadExecutor threadExecutor, PostExecutionThread postExecutionThread, Context context, Beacon beacon, long time) {
        super(threadExecutor,postExecutionThread,context);
        mBeacon=beacon;
        mTime=time;

    }
    @Override
    protected Observable buildUseCaseObservable(){
        return EventsRepository.getInstance(context,new EventJsonMapper()).sendBeaconTriggerToServer(mBeacon,EventTypeEntity.BEACON_EXIT.toString());
    }
}
