package litifer.com.sdk.domain.interactors;

import android.content.Context;
import java.io.IOException;

import litifer.com.sdk.data.mapper.EventJsonMapper;
import litifer.com.sdk.data.model.EventTypeEntity;
import litifer.com.sdk.data.model.WifiEntity;
import litifer.com.sdk.data.repository.impl.EventsRepository;
import litifer.com.sdk.domain.executor.ThreadExecutor;
import litifer.com.sdk.domain.interactors.base.AbstractInteractor;
import litifer.com.sdk.presentation.subscriber.thread.PostExecutionThread;
import rx.Observable;

/**
 * Created by kishlaykishore on 07/06/17.
 */

public class EnterWifiRegionInteractor extends AbstractInteractor{
    private String TAG="EnterWifiRegionIntr";
    private WifiEntity mWifi;

    public EnterWifiRegionInteractor(ThreadExecutor threadExecutor, PostExecutionThread postExecutionThread, Context context, WifiEntity wifiEntity) {
        super(threadExecutor,postExecutionThread,context);
        mWifi=wifiEntity;

    }

    @Override
    protected Observable buildUseCaseObservable() {
        return EventsRepository.getInstance(context,new EventJsonMapper()).sendWifiTriggerToServer(mWifi, EventTypeEntity.WIFI_ENTER.toString());
    }


}
