package litifer.com.sdk.domain.interactors;

import android.content.Context;


import org.altbeacon.beacon.Beacon;

import java.io.IOException;

import litifer.com.sdk.data.mapper.EventJsonMapper;
import litifer.com.sdk.data.model.EventTypeEntity;
import litifer.com.sdk.data.repository.impl.EventsRepository;
import litifer.com.sdk.domain.executor.ThreadExecutor;
import litifer.com.sdk.domain.interactors.base.AbstractInteractor;
import litifer.com.sdk.presentation.subscriber.thread.PostExecutionThread;
import rx.Observable;

/**
 * Created by dipu on 4/4/17.
 */

public class EnterBeaconRegionInteractor extends AbstractInteractor {
    private String TAG="EnterRegionIntr";
    private Beacon mBeacon;
    public  EnterBeaconRegionInteractor(ThreadExecutor threadExecutor, PostExecutionThread postExecutionThread, Context context, Beacon beacon) {
        super(threadExecutor,postExecutionThread,context);
        mBeacon=beacon;

    }

    @Override
    protected Observable buildUseCaseObservable() {
        return EventsRepository.getInstance(context,new EventJsonMapper()).sendBeaconTriggerToServer(mBeacon,EventTypeEntity.BEACON_ENTER.toString());
    }



}