package litifer.com.sdk.data.repository.impl;

import android.content.Context;

import java.util.ArrayList;
import java.util.List;

import litifer.com.sdk.data.exeption.NetworkConnectionException;
import litifer.com.sdk.data.mapper.GeofenceJsonMapper;
import litifer.com.sdk.data.model.GeofenceEntity;
import litifer.com.sdk.data.model.URLEntity;
import litifer.com.sdk.data.net.InternetUtility;
import rx.Observable;
import rx.Subscriber;

/**
 * Created by kishlaykishore on 22/08/17.
 */

public class GeofenceRepository {

    private  static GeofenceRepository geofenceRepository;
    private String TAG="EnterRegions";
    private GeofenceJsonMapper geofenceJsonMapper;
    private int geofireRadius = 1500;

    Context context;

    private GeofenceRepository(Context context, GeofenceJsonMapper geofenceJsonMapper) {
        if (context == null || geofenceJsonMapper == null) {
            throw new IllegalArgumentException("The constructor parameters cannot be null!!!");
        }
        this.context = context.getApplicationContext();
        this.geofenceJsonMapper = geofenceJsonMapper;
    }

    public static GeofenceRepository getInstance(Context context, GeofenceJsonMapper geofenceJsonMapper){
        if (geofenceRepository == null){
            geofenceRepository = new GeofenceRepository(context,geofenceJsonMapper);
        }
        return geofenceRepository;
    }
    public Observable getGeofencesFromServer(final double lat, final double lon) {
        return Observable.create(new Observable.OnSubscribe<List<GeofenceEntity>>() {
            @Override
            public void call(Subscriber<? super List<GeofenceEntity>> subscriber) {
                try{
                    String response= InternetUtility.getInstance(context).getCall(URLEntity.getInstance().getFetchGeofencesUrl() + "?radius=" + geofireRadius + "&lat="+lat+"&lon="+lon,subscriber);
                    subscriber.onNext(geofenceJsonMapper.transformGeofenceEntityCollection(response));
                    subscriber.onCompleted();

                }catch (Exception e){
                    subscriber.onError(new NetworkConnectionException(e));
                }    }
        });
    }
}
