package litifer.com.sdk.data.repository.impl;

import android.content.Context;
import android.util.Log;

import org.altbeacon.beacon.Beacon;


import litifer.com.sdk.data.mapper.BeaconJsonMapper;
import litifer.com.sdk.data.mapper.EventJsonMapper;
import litifer.com.sdk.data.model.BeaconEntity;
import litifer.com.sdk.data.model.URLEntity;
import litifer.com.sdk.data.model.WifiEntity;
import litifer.com.sdk.data.net.InternetUtility;
import litifer.com.sdk.data.exeption.NetworkConnectionException;
import litifer.com.sdk.presentation.Litifer;
import rx.Observable;
import rx.Subscriber;


/**
 * Created by dipu on 4/4/17.
 */

public class EventsRepository {

    private  static EventsRepository enterRegionsRepository;
    private String TAG="EnterRegions";

    Context context;


    private EventsRepository(Context context, EventJsonMapper eventJsonMapper) {
        if (context == null || eventJsonMapper == null) {
            throw new IllegalArgumentException("The constructor parameters cannot be null!!!");
        }
        this.context = context.getApplicationContext();
    }

    public static EventsRepository getInstance(Context context, EventJsonMapper eventJsonMapper){
        if (enterRegionsRepository == null){
            enterRegionsRepository = new EventsRepository(context,eventJsonMapper);
        }
        return enterRegionsRepository;
    }
    public Observable sendGeofenceTriggerToServer(final String id,final String Type){
        return Observable.create(new Observable.OnSubscribe<String>() {
            @Override
            public void call(Subscriber<? super String> subscriber) {
                try {

                    String response = InternetUtility.getInstance(context).getCall(URLEntity.getInstance().getGeoEventsUrl() + "?id="+id+"&type="+Type , subscriber);
                    subscriber.onNext(Type + ":" + response);
                    subscriber.onCompleted();
                } catch (Exception e) {
                    subscriber.onError(new NetworkConnectionException(e));
                }
            }
        });
    }
    public Observable sendBeaconTriggerToServer(final Beacon mBeacon,final String eventType) {
        return Observable.create(new Observable.OnSubscribe<String>() {
            @Override
            public void call(Subscriber<? super String> subscriber) {

                try {
                    String response = InternetUtility.getInstance(context).getCall(URLEntity.getInstance().getEventsUrl() + "?uid=" + mBeacon.getId1() + "&major="+mBeacon.getId2() +"&minor="+ mBeacon.getId3() + "&type=" + eventType, subscriber);
                    subscriber.onNext(eventType + ":" + response);
                    subscriber.onCompleted();

                } catch (Exception e) {
                    subscriber.onError(new NetworkConnectionException(e));
                }
            }
        });
    }

    public Observable sendWifiTriggerToServer(final WifiEntity mWifi, final String eventType) {
        return Observable.create(new Observable.OnSubscribe<String>() {
            @Override
            public void call(Subscriber<? super String> subscriber) {
                try{

                        String response=InternetUtility.getInstance(context).getCall(URLEntity.getInstance().getWifiEventsUrl() + "?id="+mWifi.getBSSID()+"&type="+eventType,subscriber);
                        subscriber.onNext(eventType + ":"+ response);
                        subscriber.onCompleted();

                }catch (Exception e){
                    subscriber.onError(new NetworkConnectionException(e));
                }    }
        });
    }






}