package litifer.com.sdk.data.net;

import android.content.Context;
import android.support.annotation.Nullable;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;

import org.json.JSONObject;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;

import litifer.com.sdk.data.exeption.NetworkConnectionException;
import litifer.com.sdk.data.model.ApiCallsConfig;
import litifer.com.sdk.data.model.ConfigEntity;
import okio.Buffer;
import rx.Subscriber;

/**
 * Created by kishlaykishore on 08/03/17.
 */

public class POSTApiConnection extends ApiConnection{

    private URL url;
    private JSONObject body;

    private Context mContext;
    private Subscriber subscriber;

    private POSTApiConnection(String url,JSONObject json,Context context,Subscriber subscriber) throws MalformedURLException {
        this.url = new URL(url);
        this.body = json;
        this.mContext=context;
        this.subscriber=subscriber;
    }

    public static POSTApiConnection createPOST(String url, JSONObject json, Context context, Subscriber subscriber) throws MalformedURLException {
        return new POSTApiConnection(url,json,context,subscriber);

    }

    /**
     * Do a request to an api synchronously.
     * It should not be executed in the main thread of the application.
     *
     * @return A string response
     */
    @Nullable
    public String requestSyncCall() {
        try {
            return connectToApi().body().string();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }



    protected Response connectToApi() {
        MediaType JSON = MediaType.parse(ApiCallsConfig.getInstance().CONTENT_TYPE_VALUE_JSON);
        OkHttpClient okHttpClient = this.createClient();
        okHttpClient.setReadTimeout(20, TimeUnit.SECONDS);
        okHttpClient.setWriteTimeout(20,TimeUnit.SECONDS);
        okHttpClient.setConnectTimeout(20,TimeUnit.SECONDS);
        final Request request = new Request.Builder()
                .url(this.url)
                .addHeader(ApiCallsConfig.getInstance().getCONTENT_TYPE_LABEL(), ApiCallsConfig.getInstance().getCONTENT_TYPE_VALUE_JSON())
                .addHeader(ApiCallsConfig.getInstance().getAPPLICATION_ID(),ConfigEntity.getInstance(mContext).getApplicationID() )
                .addHeader(ApiCallsConfig.getInstance().getAPPLICATION_SECRET(),ConfigEntity.getInstance(mContext).getApplicationSecret())
                .addHeader(ApiCallsConfig.getInstance().getDEVICE_TOKEN(),ConfigEntity.getInstance(mContext).getToken())
                .post(RequestBody.create(JSON,body.toString()))
                .build();
//        bodyToString(request);

        try {
            return okHttpClient.newCall(request).execute();
        } catch (IOException e) {
            e.printStackTrace();
            subscriber.onError(new NetworkConnectionException(e));
        }
        return null;
    }

    private static String bodyToString(final Request request){
        try {
            final Request copy = request.newBuilder().build();
            final Buffer buffer = new Buffer();
            copy.body().writeTo(buffer);
            return buffer.readUtf8();
        } catch (final IOException e) {
            return "did not work";
        }
    }

}
