package litifer.com.sdk.data.net;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.util.Log;

import org.json.JSONObject;

import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.List;

import rx.Subscriber;

/**
 * Created by kishlaykishore on 03/04/17.
 */

public class InternetUtility {
    private Context context;

    private static InternetUtility internetUtility;
    private String TAG="InternetUtility";

    private InternetUtility(Context context){
        this.context=context;
    }

    public static InternetUtility getInstance(Context context){
        if (internetUtility==null){
            internetUtility=new InternetUtility(context);
        }
        return internetUtility;
    }
    /**
     * Checks if the device has any active internet connection.
     *
     * @return true device with internet connection, otherwise false.
     */
    public boolean isThereInternetConnection() {
        boolean isConnected;

        ConnectivityManager connectivityManager =
                (ConnectivityManager) this.context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        isConnected = (networkInfo != null && networkInfo.isConnectedOrConnecting());

        return isConnected;
    }

    public String getCall(String url, Subscriber subscriber){
        try {
            if (InternetUtility.getInstance(context).isThereInternetConnection()) {
                return GETApiConnection.createGET(url,context,subscriber).requestSyncCall();
            }
        }catch(MalformedURLException e) {
            e.printStackTrace();
        }
        return null;

    }



    public String postCall(String url, JSONObject entity,Subscriber subscriber){
        try {
            if (InternetUtility.getInstance(context).isThereInternetConnection()) {
                return POSTApiConnection.createPOST(url,entity,context,subscriber).requestSyncCall();
            }
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;

    }

    public boolean isAppForground() {

        ActivityManager am = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningTaskInfo> tasks = am.getRunningTasks(1);
        if (!tasks.isEmpty()) {
            ComponentName topActivity = tasks.get(0).topActivity;
            if (!topActivity.getPackageName().equals(context.getPackageName())) {
                return false;
            }
        }

        return true;
    }

    public boolean isWifiEnabled() {
        boolean isWiFiEnabled = false;
        WifiManager wifi = (WifiManager)this.context.getSystemService(Context.WIFI_SERVICE);
        if(wifi.isWifiEnabled()) {
            isWiFiEnabled = true;
        }

        return isWiFiEnabled;
    }

}
