/**
 * Copyright (C) 2015 Fernando Cejas Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package litifer.com.sdk.data.net;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.content.Loader;
import android.util.Log;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.concurrent.TimeUnit;

import litifer.com.sdk.data.exeption.NetworkConnectionException;
import litifer.com.sdk.data.model.ConfigEntity;

import  litifer.com.sdk.data.model.ApiCallsConfig;
import rx.Subscriber;

/**
 * Api Connection class used to retrieve data from the cloud.
 * Implements {@link java.util.concurrent.Callable} so when executed asynchronously can
 * return a value.
 */
public class GETApiConnection extends ApiConnection {

  private URL url;
  private String response;
  private static String TAG="GETApiConnection";
  private Context mContext;
  private Subscriber subscriber;

  private GETApiConnection(String url,Context context,Subscriber subscriber) throws MalformedURLException {
    try{
      this.mContext=context;
      this.url = new URL(url);
      this.subscriber=subscriber;
    }catch (MalformedURLException e){
      e.printStackTrace();
      Log.e(TAG,e.getMessage());
    }
  }

  public static GETApiConnection createGET(String url, Context context,Subscriber subscriber) throws MalformedURLException {
    return new GETApiConnection(url,context,subscriber);
  }

  /**
   * Do a request to an api synchronously.
   * It should not be executed in the main thread of the application.
   *
   * @return A string response
   */
  @Nullable
  public String requestSyncCall() {
    try {
      return connectToApi().body().string();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return null;
  }


  protected Response connectToApi(){
    OkHttpClient okHttpClient = this.createClient();
    okHttpClient.setReadTimeout(20, TimeUnit.SECONDS);
    okHttpClient.setWriteTimeout(20,TimeUnit.SECONDS);
    okHttpClient.setConnectTimeout(20,TimeUnit.SECONDS);
    final Request request = new Request.Builder()
            .url(this.url)
            .addHeader(ApiCallsConfig.getInstance().getAPPLICATION_ID(),ConfigEntity.getInstance(mContext).getApplicationID() )
            .addHeader(ApiCallsConfig.getInstance().getAPPLICATION_SECRET(),ConfigEntity.getInstance(mContext).getApplicationSecret())
            .addHeader(ApiCallsConfig.getInstance().getDEVICE_TOKEN(),ConfigEntity.getInstance(mContext).getToken())
            .get()
            .build();



    try {
      return okHttpClient.newCall(request).execute();
    } catch (SocketTimeoutException e){
      e.printStackTrace();
        subscriber.onError(new NetworkConnectionException(e));
    } catch (IOException e) {
      e.printStackTrace();
        subscriber.onError(new NetworkConnectionException(e));
    }
    return null;
  }

}
