package litifer.com.sdk.data.net;

import android.support.annotation.Nullable;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Response;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

/**
 * Created by kishlaykishore on 08/03/17.
 */

public abstract class ApiConnection implements Callable<String> {


    /**
     * Do a request to an api synchronously.
     * It should not be executed in the main thread of the application.
     *
     * @return A string response
     */
    @Nullable
    public abstract String requestSyncCall();

    protected abstract Response connectToApi();


    protected OkHttpClient createClient() {
        final OkHttpClient okHttpClient = new OkHttpClient();
        okHttpClient.setReadTimeout(10000, TimeUnit.MILLISECONDS);
        okHttpClient.setConnectTimeout(15000, TimeUnit.MILLISECONDS);

        return okHttpClient;
    }

    @Override
    public String call() throws Exception {
        return requestSyncCall();
    }
}
