package litifer.com.sdk.data.model;

import org.altbeacon.beacon.Beacon;

import java.io.Serializable;
import java.util.Comparator;



/**
 * Created by kishlaykishore on 06/06/17.
 */

public class WifiEntity  implements Comparator<WifiEntity>, Comparable, Serializable {
        String BSSID;
        String venueName;
        String operatorFriendlyName;
        float distance;
        float frequency;
        int level;
        long timeStamp;

        public WifiEntity() {
        }

        public String getBSSID() {
            return this.BSSID;
        }

        public void setBSSID(String BSSID) {
            this.BSSID = BSSID;
        }

        public float getDistance() {
            return this.distance;
        }

        public void setDistance(float distance) {
            this.distance = distance;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public float getFrequency() {
            return this.frequency;
        }

        public void setFrequency(float frequency) {
            this.frequency = frequency;
        }

        public String getVenueName() {
            return this.venueName;
        }

        public void setVenueName(String venueName) {
            this.venueName = venueName;
        }

        public String getOperatorFriendlyName() {
            return this.operatorFriendlyName;
        }

        public void setOperatorFriendlyName(String operatorFriendlyName) {
            this.operatorFriendlyName = operatorFriendlyName;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public int compare(WifiEntity wiFiListModelOne, WifiEntity wiFiListModelTwo) {
            return wiFiListModelOne.getDistance() < wiFiListModelTwo.getDistance()?-1:(wiFiListModelOne.getDistance() > wiFiListModelTwo.getDistance()?1:0);
        }

        public int compareTo(Object o) {
            WifiEntity wiFiListModel = (WifiEntity)o;
            return this.level < wiFiListModel.getLevel()?1:(this.level > wiFiListModel.getLevel()?-1:0);
        }

        @Override
        public boolean equals(Object that) {
            if(!(that instanceof WifiEntity)) {
                return false;
            } else {
                WifiEntity thatWifi = (WifiEntity) that;
//                return !this.mIdentifiers.equals(thatBeacon.mIdentifiers)?false:(sHardwareEqualityEnforced?this.getBluetoothAddress().equals(thatBeacon.getBluetoothAddress()):true);
                return this.BSSID.equals(thatWifi.getBSSID())?true:false;
            }
        }

        @Override
        public int hashCode() {
            return this.BSSID.hashCode();
        }



}
