package litifer.com.sdk.data.model;

/**
 * Created by kishlaykishore on 21/04/17.
 */

public class URLEntity {

    private String baseUrl = "http://api-env.pfuf3vnwv2.ap-south-1.elasticbeanstalk.com";
    final private String API_BEACONS_URL = "/apps/api/v1/beacons/";
    final private String API_EVENTS_URL = "/apps/api/v1/notify-events/";
    final private String API_REGISTER_URL = "/apps/api/v1/register/";
    final private String API_EVENTS_GEO_URL = "/apps/api/v1/notify-geofence-events/";
    final private String API_EVENTS_WIFI_URL ="/apps/api/v1/notify-wifi-events/";
    final private String API_FETCH_GEOFENCES_URL ="/apps/api/v1/geofences/";

    private static URLEntity urlEntity;

    private URLEntity(){

    }

    public static URLEntity getInstance(){
        if (urlEntity==null){
            urlEntity=new URLEntity();
        }
        return urlEntity;
    }

    public String getBeaconApi(){
        return baseUrl+API_BEACONS_URL;
    }

    public String getEventsUrl(){
        return baseUrl+API_EVENTS_URL;
    }

    public String getRegisterApi(){
        return baseUrl+API_REGISTER_URL;
    }

    public String getGeoEventsUrl(){
        return baseUrl+API_EVENTS_GEO_URL;
    }
    public String getWifiEventsUrl(){
        return baseUrl+API_EVENTS_WIFI_URL;
    }

    public String getFetchGeofencesUrl(){
        return baseUrl+ API_FETCH_GEOFENCES_URL;
    }



}
