package litifer.com.sdk.data.model;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.v4.app.NotificationCompat;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

/**
 * Created by kishlaykishore on 12/04/17.
 */

public class NotificationEntity {



    public static class InboxStyle{

        public static NotificationCompat.InboxStyle getStyle(String bigContentTitle, String[] offers, String summaryText){
            NotificationCompat.InboxStyle inboxStyle =  new NotificationCompat.InboxStyle()
                    .setBigContentTitle(bigContentTitle)
                    .setSummaryText(summaryText);
            for (String offer:offers){
                inboxStyle.addLine(offer);
            }
            return inboxStyle;
        }
    }

    public static class BigPictureStyle{

        public static NotificationCompat.BigPictureStyle getStyle(String imageUrl, String contentTitle, String summaryText){
            return new NotificationCompat.BigPictureStyle()
                    .bigPicture(getBitmapfromUrl(imageUrl))
                    .setSummaryText(summaryText)
                    .setBigContentTitle(contentTitle);
        }

        public static Bitmap getBitmapfromUrl(String imageUrl){
            Bitmap image = null;
            try {
                URL url = new URL(imageUrl);
                HttpURLConnection connection = (HttpURLConnection) url.openConnection();
                connection.setDoInput(true);
                connection.connect();
                image = BitmapFactory.decodeStream(connection.getInputStream());

            }catch (java.net.MalformedURLException e){
                e.printStackTrace();
            }catch (java.io.IOException e){
                e.printStackTrace();
            }
            return image;
        }

    }

    public static class BigTextStyle{

        public static NotificationCompat.BigTextStyle getStyle(String text, String contentTitle, String summaryText){
            return new NotificationCompat.BigTextStyle()
                    .bigText(text)
                    .setBigContentTitle(contentTitle)
                    .setSummaryText(summaryText);
        }
    }
}
