package litifer.com.sdk.data.model;

import android.content.Context;

import com.google.gson.annotations.Expose;

import litifer.com.sdk.data.local.LitiferSharedPreferences;

/**
 * Created by kishlaykishore on 19/04/17.
 */

public class ConfigEntity {

    private static ConfigEntity configEntity;


    public static String EMPTY_TOKEN="";
    private String ApplicationID;
    private String ApplicationSecret;
    private String token;
    private Context mContext;

    public boolean isBackgroundMonitoringEnabled() {
        return backgroundMonitoringEnabled;
    }

    public ConfigEntity enableBackGroundMonitoring() {
        this.backgroundMonitoringEnabled = true;
        return this;
    }

    public ConfigEntity disableBackGroundMonitoring() {
        this.backgroundMonitoringEnabled = false;
        return this;
    }

    private boolean backgroundMonitoringEnabled;

    private ConfigEntity(Context context){
        mContext=context;
    }

    public static ConfigEntity getInstance(Context context){
        if (configEntity ==null){
            configEntity = new ConfigEntity(context);
        }
        return configEntity;
    }

    public String getApplicationSecret() {
        return LitiferSharedPreferences.getInstance(mContext).retrieveKey(ApiCallsConfig.getInstance().getAPPLICATION_SECRET());
    }

    public ConfigEntity setApplicationSecret(String applicationSecret) {
        ApplicationSecret = applicationSecret;
        LitiferSharedPreferences.getInstance(mContext).storeKey(ApiCallsConfig.getInstance().getAPPLICATION_SECRET(),applicationSecret);
        return configEntity;
    }

    public String getApplicationID() {
        return LitiferSharedPreferences.getInstance(mContext).retrieveKey(ApiCallsConfig.getInstance().getAPPLICATION_ID());
    }

    public ConfigEntity setApplicationID(String applicationID) {
        ApplicationID = applicationID;
        LitiferSharedPreferences.getInstance(mContext).storeKey(ApiCallsConfig.getInstance().getAPPLICATION_ID(),applicationID);
        return configEntity;
    }

    public String getToken() {
        token= LitiferSharedPreferences.getInstance(mContext).retrieveKey(ApiCallsConfig.getInstance().getDEVICE_TOKEN());
        if (token==null){
            return EMPTY_TOKEN;
        }
        return token;
    }

    public ConfigEntity setToken(String token) {
        this.token=token;
        LitiferSharedPreferences.getInstance(mContext).storeKey(ApiCallsConfig.getInstance().getDEVICE_TOKEN(),token);
        return configEntity;
    }
}
