package litifer.com.sdk.data.mapper;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

import litifer.com.sdk.data.model.NotificationTemplateEntity;

/**
 * Created by kishlaykishore on 20/04/17.
 */

public class NotificationMapToJsonMapper {

    private final Gson gson;

    public NotificationMapToJsonMapper() {
        this.gson = new Gson();
    }

    /**
     * Transform from valid json string to {@link NotificationTemplateEntity}.
     *
     * @param remoteMessage A json representing a device details.
     * @return {@link NotificationTemplateEntity}.
     * @throws com.google.gson.JsonSyntaxException if the json string is not a valid json structure.
     */
    public NotificationTemplateEntity transformMapToNotificationModel(Map remoteMessage) throws JsonSyntaxException {
        try {
            JsonElement notificationJson = this.gson.toJsonTree(remoteMessage);
            Type entityType = new TypeToken<NotificationTemplateEntity>() {}.getType();
            NotificationTemplateEntity notificationTemplateEntity = this.gson.fromJson(notificationJson, entityType);
            return notificationTemplateEntity;
        } catch (JsonSyntaxException jsonException) {
            throw jsonException;
        }
    }

    /**
     *
     * @param jsonPayload
     * @return
     * @throws JsonSyntaxException
     */
    public String transformNotificationModelToJson(Object jsonPayload) throws JsonSyntaxException {
        try {
            return this.gson.toJson(jsonPayload);

        } catch (JsonSyntaxException jsonException) {
            throw jsonException;
        }
    }


}
