package litifer.com.sdk.data.mapper;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.List;

import litifer.com.sdk.data.model.BeaconEntity;
import litifer.com.sdk.data.model.GeofenceEntity;

/**
 * Created by dipu on 29/3/17.
 */

public class GeofenceJsonMapper {

    private final Gson gson;

    public GeofenceJsonMapper() {
        this.gson = new Gson();
    }

    /**
     * Transform from valid json string to {@link BeaconEntity}.
     *
     * @param deviceJsonResponse A json representing a device details.
     * @return {@link BeaconEntity}.
     * @throws com.google.gson.JsonSyntaxException if the json string is not a valid json structure.
     */
    public GeofenceEntity transformJsonToGeofenceModel(String deviceJsonResponse) throws JsonSyntaxException {
        try {
            Type entityType = new TypeToken<BeaconEntity>() {}.getType();
            GeofenceEntity geofenceEntity = this.gson.fromJson(deviceJsonResponse, entityType);

            return geofenceEntity;
        } catch (JsonSyntaxException jsonException) {
            throw jsonException;
        }
    }

    /**
     *
     * @param jsonPayload
     * @return
     * @throws JsonSyntaxException
     */
    public String transformBeaconModelToJson(Object jsonPayload) throws JsonSyntaxException {
        try {
            return this.gson.toJson(jsonPayload);

        } catch (JsonSyntaxException jsonException) {
            throw jsonException;
        }
    }

    /**
     * Transform from valid json string to List of {@link litifer.com.sdk.data.model.GeofenceEntity}.
     *
     * @param geofenceListJsonResponse A json representing a collection of users.
     * @return List of {@link litifer.com.sdk.data.model.GeofenceEntity}.
     * @throws com.google.gson.JsonSyntaxException if the json string is not a valid json structure.
     */
    public List<GeofenceEntity> transformGeofenceEntityCollection(String geofenceListJsonResponse)
            throws JsonSyntaxException {

        List<GeofenceEntity> geofenceEntityCollection;
        try {
            Type listOfGeofenceEntityType = new TypeToken<List<GeofenceEntity>>() {}.getType();
            geofenceEntityCollection = this.gson.fromJson(geofenceListJsonResponse, listOfGeofenceEntityType);

            return geofenceEntityCollection;
        } catch (JsonSyntaxException jsonException) {
            throw jsonException;
        }
    }
}
