/**
 * Copyright (C) 2015 Fernando Cejas Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package litifer.com.sdk.data.mapper;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;

import litifer.com.sdk.data.model.DeviceEntity;

/**
 * Class used to transform from Strings representing json to valid objects.
 */
public class DeviceJsonMapper {

  private final Gson gson;

  public DeviceJsonMapper() {
    this.gson = new Gson();
  }

  /**
   * Transform from valid json string to {@link DeviceEntity}.
   *
   * @param deviceJsonResponse A json representing a device details.
   * @return {@link DeviceEntity}.
   * @throws com.google.gson.JsonSyntaxException if the json string is not a valid json structure.
   */
  public DeviceEntity transformJsonToDeviceModel(String deviceJsonResponse) throws JsonSyntaxException {
    try {
      Type userEntityType = new TypeToken<DeviceEntity>() {}.getType();
      DeviceEntity deviceEntity = this.gson.fromJson(deviceJsonResponse, userEntityType);

      return deviceEntity;
    } catch (JsonSyntaxException jsonException) {
      throw jsonException;
    }
  }

  /**
   *
   * @param jsonPayload
   * @return
   * @throws JsonSyntaxException
     */
  public String transformDeviceModelToJson(Object jsonPayload) throws JsonSyntaxException {
    try {
      return this.gson.toJson(jsonPayload);

    } catch (JsonSyntaxException jsonException) {
      throw jsonException;
    }
  }
  /**
   * Transform from valid json string to List of {@link UserEntity}.
   *
   * @param userListJsonResponse A json representing a collection of users.
   * @return List of {@link UserEntity}.
   * @throws com.google.gson.JsonSyntaxException if the json string is not a valid json structure.
   */
//  public List<UserEntity> transformUserEntityCollection(String userListJsonResponse)
//      throws JsonSyntaxException {
//
//    List<UserEntity> userEntityCollection;
//    try {
//      Type listOfUserEntityType = new TypeToken<List<UserEntity>>() {}.getType();
//      userEntityCollection = this.gson.fromJson(userListJsonResponse, listOfUserEntityType);
//
//      return userEntityCollection;
//    } catch (JsonSyntaxException jsonException) {
//      throw jsonException;
//    }
//  }
}
