package litifer.com.sdk.data.mapper;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;

import litifer.com.sdk.data.model.CustomerEntity;
import litifer.com.sdk.data.model.DeviceEntity;

/**
 * Created by kishlaykishore on 11/04/17.
 */

public class CustomerJsonMapper {

    private final Gson gson;

    public CustomerJsonMapper() {
        this.gson = new Gson();
    }


    /**
     * Transform from valid json string to {@link CustomerEntity}.
     *
     * @param customerJsonResponse A json representing a device details.
     * @return {@link CustomerEntity}.
     * @throws com.google.gson.JsonSyntaxException if the json string is not a valid json structure.
     */
    public CustomerEntity transformJsonToCustomerModel(String customerJsonResponse) throws JsonSyntaxException {
        try {
            Type customerEntityType= new TypeToken<DeviceEntity>() {}.getType();
            CustomerEntity customerEntity= this.gson.fromJson(customerJsonResponse, customerEntityType);
            return customerEntity;

        } catch (JsonSyntaxException jsonException) {
            throw jsonException;
        }
    }


    /**
     * @param jsonPayload
     * @return
     * @throws JsonSyntaxException
     */
    public String transformCustomerEntityToJson(Object jsonPayload) throws JsonSyntaxException {
        try {
            return this.gson.toJson(jsonPayload);
        } catch (JsonSyntaxException jsonException) {
            throw jsonException;
        }
    }
}
