package litifer.com.sdk.data.mapper;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.List;

import litifer.com.sdk.data.model.BeaconEntity;

/**
 * Created by kishlaykishore on 25/03/17.
 */

public class BeaconJsonMapper {

    private final Gson gson;

    public BeaconJsonMapper() {
        this.gson = new Gson();
    }

    /**
     * Transform from valid json string to {@link BeaconEntity}.
     *
     * @param deviceJsonResponse A json representing a device details.
     * @return {@link BeaconEntity}.
     * @throws com.google.gson.JsonSyntaxException if the json string is not a valid json structure.
     */
    public BeaconEntity transformJsonToBeaconModel(String deviceJsonResponse) throws JsonSyntaxException {
        try {
            Type entityType = new TypeToken<BeaconEntity>() {}.getType();
            BeaconEntity beaconEntity = this.gson.fromJson(deviceJsonResponse, entityType);

            return beaconEntity;
        } catch (JsonSyntaxException jsonException) {
            throw jsonException;
        }
    }

    /**
     *
     * @param jsonPayload
     * @return
     * @throws JsonSyntaxException
     */
    public String transformBeaconModelToJson(Object jsonPayload) throws JsonSyntaxException {
        try {
            return this.gson.toJson(jsonPayload);

        } catch (JsonSyntaxException jsonException) {
            throw jsonException;
        }
    }

    /**
     * Transform from valid json string to List of {@link litifer.com.sdk.data.model.BeaconEntity}.
     *
     * @param beaconListJsonResponse A json representing a collection of users.
     * @return List of {@link litifer.com.sdk.data.model.BeaconEntity}.
     * @throws com.google.gson.JsonSyntaxException if the json string is not a valid json structure.
     */
  public List<BeaconEntity> transformUserEntityCollection(String beaconListJsonResponse)
      throws JsonSyntaxException {

    List<BeaconEntity> beaconEntityCollection;
    try {
      Type listOfBeaconEntityType = new TypeToken<List<BeaconEntity>>() {}.getType();
      beaconEntityCollection = this.gson.fromJson(beaconListJsonResponse, listOfBeaconEntityType);

      return beaconEntityCollection;
    } catch (JsonSyntaxException jsonException) {
      throw jsonException;
    }
  }
}
